/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import com.google.common.base.Optional;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.IMuleRuntimeChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.project.DocumentationSection;
import org.mule.tooling.ui.project.DomainSettingsSection;
import org.mule.tooling.ui.project.MuleProjectEditor;
import org.mule.tooling.ui.project.RuntimeSection;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleProjectOverviewPage
extends FormPage
implements Observer {
    public static final String PAGE_ID = "mule.project.configuration";
    protected DocumentationSection documentation;
    protected RuntimeSection runtime;
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private DomainSettingsSection domainSettings;
    public static final int LABEL_WIDTH_HINT = 120;

    public MuleProjectOverviewPage(MuleProjectEditor editor) {
        super((FormEditor)editor, PAGE_ID, "Overview");
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        form.setImage(MuleImages.PROJECT_TITLE_IMAGE);
        this.updateFormTitle();
        this.fillBody(managedForm, toolkit);
        IMuleProject muleProject = this.getMuleProject();
        this.documentation.setFormInput(muleProject);
        this.runtime.setFormInput(muleProject);
        if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            this.domainSettings.setFormInput(muleProject);
        }
        muleProject.addObserver((Observer)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_EVENT, (IEventHandler)new UpdateDomainsComboListener(this.runtime, this.getMuleProject()));
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_RUNTIME_CHANGED, (IEventHandler)new UpdateRuntimeListener(this.runtime, this.getMuleProject()));
    }

    protected void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        body.setLayout((Layout)layout);
        this.runtime = new RuntimeSection(body, toolkit, 256);
        managedForm.addPart((IFormPart)this.runtime);
        TableWrapData runtimeLayoutData = new TableWrapData(256);
        this.runtime.getSection().setLayoutData((Object)runtimeLayoutData);
        this.documentation = new DocumentationSection(body, toolkit, 256);
        managedForm.addPart((IFormPart)this.documentation);
        TableWrapData docLayoutData = new TableWrapData(256);
        docLayoutData.rowspan = 2;
        docLayoutData.valign = 128;
        this.documentation.getSection().setLayoutData((Object)docLayoutData);
        IMuleProject muleProject = this.getMuleProject();
        if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            this.domainSettings = new DomainSettingsSection(body, toolkit, 256);
            managedForm.addPart((IFormPart)this.domainSettings);
            TableWrapData envLayoutData = new TableWrapData(256);
            this.domainSettings.getSection().setLayoutData((Object)envLayoutData);
        }
    }

    protected IMuleProject getMuleProject() {
        return ((MuleProjectEditor)this.getEditor()).getMuleProject();
    }

    protected void updateFormTitle() {
        ScrolledForm form = this.getManagedForm().getForm();
        form.setText("Mule Project Overview - " + this.getMuleProject().getName());
    }

    @Override
    public void update(Observable o, final Object arg) {
        if (Display.getCurrent() != null) {
            this.doUpdate(arg);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MuleProjectOverviewPage.this.doUpdate(arg);
                }
            });
        }
    }

    private void doUpdate(Object arg) {
        if ("name".equals(arg)) {
            this.updateFormTitle();
        } else if ("prop_domain".equals(arg)) {
            try {
                this.runtime.reload(this.getMuleProject());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"There was a problem reloading the available domains", (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.eventBusHelper.unregister();
        super.dispose();
        IMuleProject muleProject = this.getMuleProject();
        if (muleProject != null) {
            muleProject.deleteObserver((Observer)this);
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    private static final class UpdateDomainsComboListener
    implements IMuleProjectEventListener {
        private RuntimeSection runtime;
        private IMuleProject muleProject;

        public UpdateDomainsComboListener(RuntimeSection runtime, IMuleProject muleProject) {
            this.runtime = runtime;
            this.muleProject = muleProject;
        }

        public void onMuleProjectClosed(IProject project) {
            if (MuleProjectKind.APPLICATION.classifies(this.muleProject)) {
                this.reloadDomainsInput();
            }
        }

        public void onMuleProjectOpened(IProject project) {
            try {
                if (MuleProjectKind.APPLICATION.classifies(this.muleProject) && MuleProjectKind.DOMAIN.classifies(project)) {
                    this.reloadDomainsInput();
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("There was a problem trying to know the nature of project: " + String.valueOf(project)), (Throwable)e);
            }
        }

        private void reloadDomainsInput() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        runtime.reload(muleProject);
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError((String)"There was a problem reloading the available domains", (Throwable)e);
                    }
                }
            });
        }
    }

    private static final class UpdateRuntimeListener
    implements IMuleRuntimeChangedListener {
        private RuntimeSection runtime;
        private IMuleProject muleProject;

        public UpdateRuntimeListener(RuntimeSection runtime, IMuleProject muleProject) {
            this.runtime = runtime;
            this.muleProject = muleProject;
        }

        public void beforeChanging(String fromId, String toId, IMuleProject muleProject) {
        }

        public void afterChanging(String fromId, String toId, final IMuleProject muleProject) {
            if (muleProject.getProject().equals((Object)this.muleProject.getProject())) {
                ((Display)Optional.fromNullable((Object)Display.getCurrent()).or((Object)Display.getDefault())).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runtime.reload(muleProject);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }
}

