/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.project.MuleProjectOverviewPage;

public class MuleProjectEditor
extends FormEditor
implements Observer,
IResourceChangeListener {
    public static final String EDITOR_ID = "org.mule.tooling.ui.muleProjectEditor";
    protected MuleProjectOverviewPage general;
    protected IFile configFile;
    protected IMuleProject muleProject;
    protected boolean dirty;

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    protected void addPages() {
        try {
            this.general = new MuleProjectOverviewPage(this);
            this.addPage((IFormPage)this.general);
            this.muleProject.addObserver((Observer)this.general);
            this.muleProject.addObserver((Observer)this);
        }
        catch (PartInitException e) {
            MuleUIPlugin.getDefault().logError(e.getMessage());
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.configFile = (IFile)input.getAdapter(IFile.class);
        this.setPartName(this.configFile.getName());
        this.muleProject = MuleRuntime.create((IProject)this.configFile.getProject());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.configFile != null && event.getDelta() != null) {
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().equals((Object)MuleProjectEditor.this.configFile) && delta.getKind() == 2) {
                        MuleProjectEditor.this.close(false);
                        return false;
                    }
                    return true;
                }
            };
            try {
                event.getDelta().accept(visitor);
            }
            catch (CoreException e) {
                MuleCorePlugin.getLog().log(e.getStatus());
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.commitPages(true);
            this.muleProject.save();
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error Saving", (String)"Unable to save project configuration.", (IStatus)e.getStatus());
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.dirty = true;
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MuleProjectEditor.this.firePropertyChange(257);
                }
            });
        } else {
            this.firePropertyChange(257);
        }
    }

    public void close(boolean save) {
        super.close(save);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void editorDirtyStateChanged() {
        this.dirty = true;
        super.editorDirtyStateChanged();
    }
}

