/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.ui.m2.dependency.MavenDependencyPicker;

public class MavenDependencyPickerDialog
extends Dialog {
    private MavenDependencyPicker picker;
    private String defaultClassifier = "mule-plugin";
    private String defaultArtifact;
    private MavenDependency.Scope defaultScope = MavenDependency.Scope.PROVIDED;
    private String defaultType = "jar";
    private boolean allowsTypeChange = true;
    private boolean allowsClassifierChange = true;

    public MavenDependencyPickerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Maven Dependency");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(dialogComposite);
        this.createPicker(dialogComposite);
        this.createButtons(dialogComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogComposite);
        return dialogComposite;
    }

    private void createPicker(Composite parent) {
        this.picker = MavenDependencyPicker.create(Optional.empty(), null);
        this.picker.setDefaultArtifact(this.getDefaultArtifact());
        this.picker.setDefaultGroupId("com.mycompany");
        this.picker.setDefaultVersion("1.0.0-SNAPSHOT");
        this.picker.setDefaultScope(this.getDefaultScope());
        this.picker.setDefaultClassifier(this.getDefaultClassifier());
        this.picker.setDefaultType(this.getDefaultType());
        this.picker.setAllowsClassifierChange(this.allowsClassifierChange);
        this.picker.setAllowsTypeChange(this.allowsTypeChange);
        Control pickerControl = this.picker.createControl(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(600, -1).applyTo(pickerControl);
    }

    private void createButtons(Composite pickerComposite) {
        Composite buttonsComposite = new Composite(pickerComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonsComposite);
        this.createButton(buttonsComposite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(buttonsComposite, 0, IDialogConstants.OK_LABEL, true);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)buttonsComposite);
    }

    public MavenDependency getDependency() {
        return this.picker.getDependency();
    }

    public String getDefaultClassifier() {
        return this.defaultClassifier;
    }

    public String getDefaultArtifact() {
        return this.defaultArtifact;
    }

    public MavenDependency.Scope getDefaultScope() {
        return this.defaultScope;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public boolean getAllowsTypeChange() {
        return this.allowsTypeChange;
    }

    public void setDefaultArtifact(String defaultArtifact) {
        this.defaultArtifact = defaultArtifact;
    }

    public void setDefaultClassifier(String defaultClassifier) {
        this.defaultClassifier = defaultClassifier;
    }

    public void setAllowsTypeChange(boolean allows) {
        this.allowsTypeChange = allows;
    }

    public void setAllowsClassifierChange(boolean allows) {
        this.allowsClassifierChange = allows;
    }

    public boolean getAllowsClassifierChange() {
        return this.allowsClassifierChange;
    }

    public void setDefaultScope(MavenDependency.Scope scope) {
        this.defaultScope = scope;
    }

    public void setDefaultType(String type) {
        this.defaultType = type;
    }
}

