/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.client.api.introspection.IntrospectionFlow;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.utils.Pair;

public class FlowCountDialog
extends TitleAreaDialog {
    private static final String DIALOG_DESCRIPTION = "Total number of billable flows: %d";
    private static final String DIALOG_TITLE = "%s Flow Count";
    private static final String DISCLAIMER_INFO_TEXT = "Your Anypoint Platform Organization is charged for concurrently running billable flows that are deployed.";
    private static final String DOCUMENTATION_PAGE_LINK = "<a href=\"https://docs.mulesoft.com/studio/latest/flow-counting-studio\">Learn more</a> about billable flows and how to reduce them.";
    private static final String PROGRESS_BAR_LABEL_FLOW_COUNT = "Calculating Flows...";
    private static final int MIN_COLUMN_SIZE = 50;
    private static final int LARGE_COLUMN_WEIGHT = 23;
    private Map<String, IntrospectionFlow> introspectionFlows;
    private String projectName;
    private TableViewer tableViewer;

    public FlowCountDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public FlowCountDialog(Shell parentShell, Map<String, IntrospectionFlow> introspectionFlows, String projectName) {
        this(parentShell);
        this.introspectionFlows = introspectionFlows;
        this.projectName = projectName;
    }

    protected Point getInitialSize() {
        return new Point(1090, 625);
    }

    public void create() {
        super.create();
        this.getShell().setMinimumSize(new Point(425, 425));
        this.getShell().setText(String.format(DIALOG_TITLE, this.projectName));
        this.setMessage(String.format(DIALOG_DESCRIPTION, this.introspectionFlows.size()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite dialogContentComposite = new Composite(dialogComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogContentComposite);
        GridLayoutFactory.swtDefaults().applyTo(dialogContentComposite);
        this.createFlowsTable(dialogContentComposite);
        this.createDisclaimerArea(dialogContentComposite);
        this.populateFlows();
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createFlowsTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)tableComposite);
        GridLayoutFactory.swtDefaults().applyTo(tableComposite);
        this.tableViewer = new TableViewer(tableComposite, 68100);
        this.createColumns(tableComposite);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createColumns(Composite tableComposite) {
        TableViewerColumn column1 = this.createTableViewerColumn("Flow Name", (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Pair flow = (Pair)element;
                return (String)flow.getLeft();
            }
        });
        TableViewerColumn column2 = this.createTableViewerColumn("Type", (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Pair flow = (Pair)element;
                String type = "";
                if (((IntrospectionFlow)flow.getRight()).isTrigger()) {
                    type = "Trigger flow";
                } else if (((IntrospectionFlow)flow.getRight()).isApiImplementation()) {
                    type = "APIkit-generated flow";
                }
                return type;
            }
        });
        TableColumnLayout tableLayout = new TableColumnLayout(true);
        tableLayout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(23, 50));
        tableLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(23, 50));
        tableComposite.setLayout((Layout)tableLayout);
    }

    private TableViewerColumn createTableViewerColumn(String headerName, CellLabelProvider labelProvider) {
        TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, 16384);
        TableColumn column = columnViewer.getColumn();
        column.setText(headerName);
        column.setResizable(true);
        column.setMoveable(false);
        columnViewer.setLabelProvider(labelProvider);
        return columnViewer;
    }

    private void createDisclaimerArea(Composite parent) {
        Composite disclaimerComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)disclaimerComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(disclaimerComposite);
        Label separator = new Label(disclaimerComposite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)separator);
        Label disclaimerMessage = new Label(disclaimerComposite, 64);
        disclaimerMessage.setText(DISCLAIMER_INFO_TEXT);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)disclaimerMessage);
        Link link = new Link(disclaimerComposite, 0);
        link.setText(DOCUMENTATION_PAGE_LINK);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                Program.launch((String)"https://docs.mulesoft.com/general/pricing");
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"An error ocurred while opening the link", (Throwable)e);
            }
        }));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)link);
    }

    private void populateFlows() {
        Job job = new Job(PROGRESS_BAR_LABEL_FLOW_COUNT){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(() -> {
                    FlowCountDialog.this.tableViewer.setInput(FlowCountDialog.this.buildFlowsToDisplay(FlowCountDialog.this.introspectionFlows));
                    FlowCountDialog.this.tableViewer.getTable().setEnabled(true);
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(10);
        job.schedule();
    }

    private List<Pair<String, IntrospectionFlow>> buildFlowsToDisplay(Map<String, IntrospectionFlow> introspectionFlows) {
        return introspectionFlows.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)((IntrospectionFlow)e.getValue()))).toList();
    }
}

