/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditDomainNameDialog
extends Dialog {
    private static final boolean UPDATE_REFERENCES_DEFAULT = true;
    private String domainName;
    private boolean updateReferences = true;

    protected EditDomainNameDialog(Shell parentShell, String domainName) {
        super(parentShell);
        this.domainName = domainName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Update Domain name");
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point((int)Math.ceil((double)initialSize.x * 1.25), (int)Math.ceil((double)initialSize.y * 1.15));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)composite.getLayout())).numColumns(2).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText("New Domain name: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        final Text newNameText = new Text(composite, 2048);
        newNameText.setText(this.domainName);
        newNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditDomainNameDialog.this.domainName = newNameText.getText();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)newNameText);
        final Button updateRefsButton = new Button(composite, 32);
        updateRefsButton.setText("Update domain references");
        updateRefsButton.setSelection(true);
        updateRefsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDomainNameDialog.this.updateReferences = updateRefsButton.getSelection();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)updateRefsButton);
        return composite;
    }

    public boolean getUpdateReferences() {
        return this.updateReferences;
    }

    public String getDomainName() {
        return this.domainName;
    }
}

