/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.ui.project.EditDomainNameDialog;

public class DomainSettingsComponent {
    private Text domainIdText;
    private IMuleDomainProject muleProject;

    public void loadFromMuleProject(IMuleDomainProject muleProject) {
        this.muleProject = muleProject;
        this.domainIdText.setText((String)Optional.fromNullable((Object)muleProject.getDomainName()).or((Object)muleProject.getProject().getName()));
    }

    public void createContent(Composite client) {
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(5, 5).applyTo(client);
        Label label = new Label(client, 0);
        label.setText("Domain name:");
        label.setToolTipText("The actual domain name which other projects will refer to and which will be used by default to deploy to the runtime server");
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(120, -1).applyTo((Control)label);
        this.domainIdText = new Text(client, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainIdText);
        Link changeLink = new Link(client, 0);
        changeLink.setText("<a>Change...</a>");
        changeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DomainSettingsComponent.this.changeDomainName();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)changeLink);
    }

    public void changeDomainName() {
        EditDomainNameDialog editDomainNameDialog = new EditDomainNameDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domainIdText.getText());
        editDomainNameDialog.setBlockOnOpen(true);
        int open = editDomainNameDialog.open();
        if (open == 0) {
            if (editDomainNameDialog.getUpdateReferences()) {
                try {
                    List childProjects = this.muleProject.getChildProjects();
                    Iterator iterator = childProjects.iterator();
                    while (iterator.hasNext()) {
                        IMuleApplicationProject cfr_ignored_0 = (IMuleApplicationProject)iterator.next();
                    }
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError((String)("There was a problem updating references to domain project " + this.muleProject.getName()), (Throwable)e);
                }
            }
            this.muleProject.setDomainName(editDomainNameDialog.getDomainName());
            this.loadFromMuleProject(this.muleProject);
        }
    }
}

