/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.ProjectUtils;
import org.mule.tooling.ui.MuleImages;

public class DataSenseProjectComponent {
    private IMuleProject muleProject;
    private Button dataSenseWithResourcesButton;
    private Table dependencyTable;
    private CheckboxTableViewer dependencyTableViewer;
    private static final String WARNING_TEXT = "WARNING: Enabling this preference might heavily impact DataSense performance. Also, if several dependencies have resources with the same name, its results might be affected.\nDo NOT enable this unless you know what you are doing.";

    public void createContent(Composite composite) {
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.dataSenseWithResourcesButton = new Button(composite, 32);
        this.dataSenseWithResourcesButton.setImage(MuleImages.WARN_EDITOR_IMAGE);
        this.dataSenseWithResourcesButton.setText("Add resources from dependencies for DataSense (EXPERIMENTAL)");
        this.dataSenseWithResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSenseProjectComponent.this.dependencyTable.setEnabled(DataSenseProjectComponent.this.dataSenseWithResourcesButton.getSelection());
            }
        });
        Label warningText = new Label(composite, 64);
        warningText.setText(WARNING_TEXT);
        GridDataFactory.fillDefaults().grab(true, false).hint(350, 50).applyTo((Control)warningText);
        this.dependencyTable = new Table(composite, 67618);
        this.dependencyTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().hint(350, 250).grab(true, true).applyTo((Control)this.dependencyTable);
        TableColumn column = new TableColumn(this.dependencyTable, 0);
        column.setWidth(400);
        this.dependencyTableViewer = new CheckboxTableViewer(this.dependencyTable);
        this.dependencyTableViewer.setLabelProvider((IBaseLabelProvider)new DependencyLabelProvider());
        this.dependencyTableViewer.setContentProvider((IContentProvider)new DependencyContentProvider());
    }

    public void loadFromMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
        if (muleProject != null) {
            boolean value = ProjectUtils.shouldResolveDataSenseWithDependencyResources((IMuleProject)muleProject);
            this.dataSenseWithResourcesButton.setSelection(value);
            this.dependencyTable.setEnabled(value);
            this.dependencyTableViewer.setInput((Object)muleProject.getModuleManager().getExternalModules().toArray());
            this.loadCheckedElements(muleProject);
        }
    }

    private void loadCheckedElements(IMuleProject muleProject) {
        List checkedResources = ProjectUtils.getDependenciesForExperimentalDataSense((IMuleProject)muleProject);
        if (!checkedResources.isEmpty()) {
            this.dependencyTableViewer.setCheckedElements(checkedResources.toArray());
        }
    }

    public void commit() {
        ProjectUtils.setExperimentalDataSensePrefs((IMuleProject)this.muleProject, (boolean)this.dataSenseWithResourcesButton.getSelection(), (Object[])this.dependencyTableViewer.getCheckedElements());
    }

    private class DependencyContentProvider
    implements IStructuredContentProvider {
        private DependencyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return DataSenseProjectComponent.this.muleProject.getModuleManager().getExternalModules().toArray();
        }
    }

    private class DependencyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DependencyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ExternalContributionMuleModule) {
                ExternalContributionMuleModule module = (ExternalContributionMuleModule)element;
                MavenCoordinates coords = module.getCoordinates();
                if (columnIndex == 0) {
                    return String.join((CharSequence)":", coords.getGroupId(), coords.getArtifactId());
                }
                return "";
            }
            return "";
        }
    }
}

