/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.project;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.project.RuntimeConfigurationComponent;

final class ChangeServerSelectionListener
implements ISelectionChangedListener {
    private static final String MESSAGE_CHANGE_RUNTIME = "You will change the project Mule runtime version. \n";
    private static final String MESSAGE_INCOMPATIBILITY = "You will change the project Mule runtime version. For AsyncAPI implementations, select Mule runtime 4.6 or later. Do you want to proceed? \n";
    private static final String TITLE_VERSION_CHANGE = "Mule Runtime Version Change";
    private final RuntimeConfigurationComponent runtimeSection;
    private final Composite client;
    private static final String[] LABELS = new String[]{"Proceed", "Cancel"};

    ChangeServerSelectionListener(RuntimeConfigurationComponent runtimeConfigurationComponent, Composite client) {
        this.runtimeSection = runtimeConfigurationComponent;
        this.client = client;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IMuleProject muleProject = this.runtimeSection.getMuleProject();
        IServerDefinition selectedServer = this.runtimeSection.getSelectedServer();
        IServerDefinition previousServer = muleProject.getServerDefinition();
        if (!previousServer.equals(selectedServer)) {
            MessageDialog dialog = this.createDialog(muleProject, previousServer, selectedServer);
            int acceptQuestion = dialog.open();
            if (acceptQuestion == 0) {
                try {
                    this.runtimeSection.commit();
                    muleProject.save();
                    this.runtimeSection.loadFromMuleProject(muleProject);
                }
                catch (CoreException e) {
                    MuleUIPlugin.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), e.getStatus());
                }
            } else {
                this.runtimeSection.loadFromMuleProject(muleProject);
            }
        }
    }

    private MessageDialog createDialog(IMuleProject muleProject, IServerDefinition previous, IServerDefinition selected) {
        boolean isRuntimeCompatibleWithAsyncAPI = CoreUtils.isRuntimeCompatibleWithAsyncAPI((List)muleProject.getDeclaredDependencies(), (IServerDefinition)selected);
        String message = isRuntimeCompatibleWithAsyncAPI ? MESSAGE_CHANGE_RUNTIME : MESSAGE_INCOMPATIBILITY;
        return new MessageDialog(this.client.getShell(), TITLE_VERSION_CHANGE, null, this.getMessage(previous, selected, message), 4, LABELS, 0);
    }

    private String getMessage(IServerDefinition previous, IServerDefinition selected, String description) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(description);
        if (previous.isEnterpriseRuntime() != selected.isEnterpriseRuntime()) {
            this.buildProjectDependentMessage(selected, messageBuilder);
        }
        messageBuilder.append("Do you want to proceed?");
        String message = messageBuilder.toString();
        return message;
    }

    private void buildProjectDependentMessage(IServerDefinition selected, StringBuilder messageBuilder) {
        IMuleProject muleProject = this.runtimeSection.getMuleProject();
        boolean isMuleApplication = MuleProjectKind.APPLICATION.classifies(muleProject);
        boolean isDomainProject = MuleProjectKind.DOMAIN.classifies(muleProject);
        if (isMuleApplication) {
            messageBuilder.append(MessageFormat.format("This may require a namespace update of all flows in project ''{0}''", muleProject.getName()));
            messageBuilder.append(".\n");
        } else if (isDomainProject) {
            messageBuilder.append(MessageFormat.format("This requires manually changing or adding the enterprise domains namespace in the {0} file ", IMuleResources.MULE_DOMAIN_CONFIG_FILE_NAME));
            if (this.domainProjectHasChildren()) {
                messageBuilder.append("and updating the runtime of all projects associated to this domain");
                messageBuilder.append(".\n");
            } else {
                messageBuilder.append(".\n");
            }
        }
    }

    private boolean domainProjectHasChildren() {
        try {
            return !((IMuleDomainProject)MuleProjectKind.DOMAIN.adapt(this.runtimeSection.getMuleProject())).getChildProjects().isEmpty();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

