/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences.extension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.ui.PreferenceContributionExtension;
import org.mule.tooling.ui.preferences.extension.PreferenceContributionProvider;

public abstract class PreferenceContributionPage
extends FieldEditorPreferencePage {
    private Map<IPreferenceStore, List<FieldEditor>> preferenceContributionsFieldEditors = new HashMap<IPreferenceStore, List<FieldEditor>>();

    public PreferenceContributionPage() {
    }

    public PreferenceContributionPage(int style) {
        super(style);
    }

    public PreferenceContributionPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    public PreferenceContributionPage(String title, int style) {
        super(title, style);
    }

    protected abstract String getPreferencePageId();

    protected void createFieldEditors() {
        Composite preferenceComposite = this.getFieldEditorParent();
        List<PreferenceContributionExtension> extensions = PreferenceContributionExtension.findAll(this.getPreferencePageId());
        for (PreferenceContributionExtension extension : extensions) {
            PreferenceContributionProvider contribution = extension.getProvider();
            contribution.createLayout(preferenceComposite);
            List<FieldEditor> fieldEditors = contribution.createFieldEditors(preferenceComposite);
            this.addFields(fieldEditors);
            this.preferenceContributionsFieldEditors.put(extension.getPreferenceStore(), fieldEditors);
        }
    }

    protected void initialize() {
        for (Map.Entry<IPreferenceStore, List<FieldEditor>> preferenceContributionFieldEditor : this.preferenceContributionsFieldEditors.entrySet()) {
            IPreferenceStore store = preferenceContributionFieldEditor.getKey();
            List<FieldEditor> fieldEditors = preferenceContributionFieldEditor.getValue();
            for (FieldEditor fieldEditor : fieldEditors) {
                fieldEditor.setPage((DialogPage)this);
                fieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
                fieldEditor.setPreferenceStore(store);
                fieldEditor.load();
            }
        }
    }

    private void addFields(List<FieldEditor> fieldEditors) {
        for (FieldEditor fieldEditor : fieldEditors) {
            this.addField(fieldEditor);
        }
    }
}

