/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.SourceAttachmentChangedEvent;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.MuleServerManager;
import org.mule.tooling.core.runtime.sources.SourceAttachmentPreferences;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.widgets.tree.model.EmptyGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.utils.eventbus.IEvent;

public class SourceAttachmentsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NONE = "none";
    private static final String LABEL_EDIT = "Edit";
    private static final String LABEL_CLEAR = "Clear";
    private static final String[] EXTENSIONS = new String[]{"*.zip"};
    private Map<IServerDefinition, String> currentValues = new HashMap<IServerDefinition, String>();
    private IServerDefinition selectedServer;
    private TreeViewer treeViewer;
    private Button editButton;
    private Button clearButton;
    private boolean isDirty = false;

    public SourceAttachmentsPreferencePage() {
    }

    public SourceAttachmentsPreferencePage(String title) {
        super(title);
    }

    public SourceAttachmentsPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(MuleUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Manage source code attachment options for Mule runtimes");
        this.initializeCurrentValues();
    }

    private void initializeCurrentValues() {
        List serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        Collection eeServerDefinitions = CollectionUtils.select((Collection)serverDefinitions, (Predicate)this.isEnterprise());
        for (IServerDefinition serverDefinition : eeServerDefinitions) {
            String attachment = serverDefinition.getEnterpriseSourceFilePath() != null ? serverDefinition.getEnterpriseSourceFilePath().toOSString() : NONE;
            this.currentValues.put(serverDefinition, attachment);
        }
    }

    private Predicate isEnterprise() {
        return new Predicate(){

            public boolean evaluate(Object object) {
                return ((IServerDefinition)object).isEnterpriseRuntime();
            }
        };
    }

    public boolean performOk() {
        boolean performOk = super.performOk();
        if (performOk && this.isDirty) {
            final SourceAttachmentPreferences sourceAttachmentPreferences = SourceAttachmentPreferences.get();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            try {
                progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Set<Map.Entry<IServerDefinition, String>> entrySet = SourceAttachmentsPreferencePage.this.currentValues.entrySet();
                        for (Map.Entry<IServerDefinition, String> entry : entrySet) {
                            SourceAttachmentsPreferencePage.this.applyEntryChanges(sourceAttachmentPreferences, entry);
                        }
                        SourceAttachmentsPreferencePage.this.isDirty = !sourceAttachmentPreferences.save();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MuleUIPlugin.openError(this.getShell(), e);
            }
        }
        return !this.isDirty;
    }

    private void applyEntryChanges(SourceAttachmentPreferences sourceAttachmentPreferences, Map.Entry<IServerDefinition, String> entry) {
        String previousValue;
        IServerDefinition serverDefinition = entry.getKey();
        String attachment = entry.getValue();
        String string = previousValue = serverDefinition.getEnterpriseSourceFilePath() != null ? serverDefinition.getEnterpriseSourceFilePath().toOSString() : NONE;
        if (!attachment.equals(previousValue)) {
            this.saveAndNotify(serverDefinition, attachment, sourceAttachmentPreferences);
        }
    }

    private void saveAndNotify(IServerDefinition serverDefinition, String attachment, SourceAttachmentPreferences sourceAttachmentPreferences) {
        IPath path = attachment == NONE ? null : Path.fromOSString((String)attachment);
        serverDefinition.setEnterpriseSourceFilePath(path);
        sourceAttachmentPreferences.setSourceAttachment(serverDefinition, (IPath)(path != null ? path : Path.EMPTY));
        MuleCorePlugin.getEventBus().fireEvent((IEvent)SourceAttachmentChangedEvent.enterpriseSourcesChanged((IServerDefinition)serverDefinition, (IPath)path));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createTreeViewer(composite);
        this.createButtons(composite);
        this.setControl((Control)parent);
        return parent;
    }

    private void createButtons(Composite composite) {
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonsComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonsComposite);
        this.editButton = new Button(buttonsComposite, 0);
        this.editButton.setText(LABEL_EDIT);
        this.editButton.setEnabled(false);
        GridDataFactory.swtDefaults().align(0x1000000, 1).hint(100, -1).applyTo((Control)this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceAttachmentsPreferencePage.this.editButtonSelected();
            }
        });
        this.clearButton = new Button(buttonsComposite, 0);
        this.clearButton.setText(LABEL_CLEAR);
        this.clearButton.setEnabled(false);
        GridDataFactory.swtDefaults().align(0x1000000, 1).hint(100, -1).applyTo((Control)this.clearButton);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceAttachmentsPreferencePage.this.clearButtonSelected();
            }
        });
    }

    protected void clearButtonSelected() {
        this.setCurrentValueUpdatingDirtyState(this.getSelectedServer(), NONE);
        this.treeViewer.refresh();
    }

    private void editButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(EXTENSIONS);
        String filePath = fileDialog.open();
        if (filePath != null) {
            this.setCurrentValueUpdatingDirtyState(this.getSelectedServer(), filePath);
            this.treeViewer.refresh();
        }
    }

    private void setCurrentValueUpdatingDirtyState(IServerDefinition server, String filePath) {
        String previousValue = this.currentValues.put(server, filePath);
        this.isDirty = this.isDirty || !this.nullSafeEquals(previousValue, filePath);
    }

    protected void performDefaults() {
        for (IServerDefinition server : this.currentValues.keySet()) {
            this.setCurrentValueUpdatingDirtyState(server, NONE);
        }
        this.treeViewer.refresh();
        super.performDefaults();
    }

    protected IServerDefinition getSelectedServer() {
        return this.selectedServer;
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider(){

            public String getText(Object element) {
                return super.getText(element) + " ";
            }
        });
        this.treeViewer.setInput((Object)new GraphicalTreeNode("", "", (Object)MuleCorePlugin.getServerManager(), (IGraphicalChildrenProvider)new RootChildrenProvider()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeViewer.getControl());
        this.treeViewer.expandAll();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    SourceAttachmentsPreferencePage.this.selectedServer = null;
                    SourceAttachmentsPreferencePage.this.setButtonsEnablement(false);
                } else {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    GraphicalTreeNode firstElement = (GraphicalTreeNode)selection.getFirstElement();
                    if (firstElement.getModel() instanceof IServerDefinition) {
                        SourceAttachmentsPreferencePage.this.selectedServer = null;
                        SourceAttachmentsPreferencePage.this.setButtonsEnablement(false);
                    } else if (firstElement.getModel() instanceof String) {
                        SourceAttachmentsPreferencePage.this.selectedServer = (IServerDefinition)firstElement.getParent().getModel();
                        SourceAttachmentsPreferencePage.this.setButtonsEnablement(true);
                    }
                }
            }
        });
    }

    private void setButtonsEnablement(boolean enabled) {
        this.editButton.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
    }

    private <T> boolean nullSafeEquals(T object1, T object2) {
        return object1 != null ? object1.equals(object2) : object2 == null;
    }

    private class RootChildrenProvider
    implements IGraphicalChildrenProvider<MuleServerManager> {
        private RootChildrenProvider() {
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MuleServerManager> parent) {
            ArrayList children = new ArrayList();
            List serverDefinitions = ((MuleServerManager)parent.getModel()).getServerDefinitions();
            for (IServerDefinition serverDefinition : serverDefinitions) {
                Image icon = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
                children.add(new GraphicalTreeNode(parent, serverDefinition.getLabel(), "", (Object)serverDefinition, (IGraphicalChildrenProvider)new ServerDefinitionChildrenProvider()).icon(icon));
            }
            return children;
        }
    }

    private class ServerDefinitionChildrenProvider
    implements IGraphicalChildrenProvider<IServerDefinition> {
        private ServerDefinitionChildrenProvider() {
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<IServerDefinition> parent) {
            ArrayList children = new ArrayList();
            IServerDefinition serverDefinition = (IServerDefinition)parent.getModel();
            String originalValue = serverDefinition.getEnterpriseSourceFilePath() != null ? serverDefinition.getEnterpriseSourceFilePath().toOSString() : SourceAttachmentsPreferencePage.NONE;
            String currentValue = SourceAttachmentsPreferencePage.this.currentValues.get(serverDefinition);
            String attachment = currentValue != null ? currentValue : originalValue;
            Image icon = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.classf_obj.gif");
            children.add(new GraphicalTreeNode(parent, "Enterprise sources: " + attachment, "", (Object)attachment, (IGraphicalChildrenProvider)new EmptyGraphicalChildrenProvider()).icon(icon));
            return children;
        }
    }
}

