/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class RuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DEFAULT_MULE_RUNTIME_SELECTION = "default_mule_runtime_selection";
    public static final String ENABLE_FIPS_SUPPORT = "enable_fips_support";
    private IServerDefinition selectedServerDefinition;
    private BooleanFieldEditor fipsSupportFieldEditor;

    public void init(IWorkbench workbench) {
        this.setDescription("Select the default runtime and configure runtime options");
        this.setPreferenceStore(MuleUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.addDefaultRuntimeProperties(composite);
        this.addFipsProperties(composite);
        return composite;
    }

    private void addFipsProperties(Composite parent) {
        this.fipsSupportFieldEditor = new BooleanFieldEditor(ENABLE_FIPS_SUPPORT, "&Enable FIPS support in Mule runtime", parent);
        this.fipsSupportFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.fipsSupportFieldEditor.load();
    }

    private void addDefaultRuntimeProperties(Composite parent) {
        ServerChooserComponent serverChooserComponent = new ServerChooserComponent("Default Runtime selection");
        Control control = serverChooserComponent.createControl(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        serverChooserComponent.setServerDefinition(new MuleStudioPreference().getDefaultRuntimeSelection());
        serverChooserComponent.setStatusHandler(new NaiveStatusHandler(){

            @Override
            public void notifyUpdate(WizardPagePartExtension part, String key, Object value) {
                if ("serverDefinition".equals(key)) {
                    RuntimesPreferencePage.this.selectedServerDefinition = (IServerDefinition)value;
                }
            }
        });
    }

    public boolean performOk() {
        if (this.selectedServerDefinition != null) {
            this.getPreferenceStore().setValue(DEFAULT_MULE_RUNTIME_SELECTION, this.selectedServerDefinition.getId());
        }
        if (this.fipsSupportFieldEditor != null) {
            this.fipsSupportFieldEditor.store();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        if (this.fipsSupportFieldEditor != null) {
            this.fipsSupportFieldEditor.loadDefault();
        }
        super.performDefaults();
    }
}

