/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import java.util.HashMap;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class PerspectivePreferences {
    public static final String PERSPECTIVE_SWITCH_PROJECT_MULE = "studio.perspective.switch.project.mule";
    public static final String PERSPECTIVE_SWITCH_PROJECT_API = "studio.perspective.switch.project.api";
    public static final String PERSPECTIVE_SWITCH_PROJECT_JAVA = "studio.perspective.switch.project.java";
    public static final String API_PROJECT_PERSPECTIVE_ID = "org.mule.tooling.ui.apiproject.perspective";
    public static final String MULE_PROJECT_PERSPECTIVE_ID = "org.mule.tooling.ui.toolingPerspective";
    public static final String JAVA_PROJECT_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    private static HashMap<String, String> perspectiveNameByID = new HashMap();
    private static HashMap<String, String> preferenceStoreKeyByPerspectiveID = new HashMap();

    static {
        perspectiveNameByID.put(API_PROJECT_PERSPECTIVE_ID, "API Design");
        perspectiveNameByID.put(MULE_PROJECT_PERSPECTIVE_ID, "Mule Design");
        perspectiveNameByID.put(JAVA_PROJECT_PERSPECTIVE_ID, "Java Project");
        preferenceStoreKeyByPerspectiveID.put(API_PROJECT_PERSPECTIVE_ID, PERSPECTIVE_SWITCH_PROJECT_API);
        preferenceStoreKeyByPerspectiveID.put(MULE_PROJECT_PERSPECTIVE_ID, PERSPECTIVE_SWITCH_PROJECT_MULE);
        preferenceStoreKeyByPerspectiveID.put(JAVA_PROJECT_PERSPECTIVE_ID, PERSPECTIVE_SWITCH_PROJECT_JAVA);
    }

    private PerspectivePreferences() {
        throw new IllegalCreationException();
    }

    public static String getPerspectiveSwitchMuleProjectPreference() {
        return MuleUIPlugin.getDefault().getPreferenceStore().getString(PERSPECTIVE_SWITCH_PROJECT_MULE);
    }

    public static String getPerspectiveSwitchApiProjectPreference() {
        return MuleUIPlugin.getDefault().getPreferenceStore().getString(PERSPECTIVE_SWITCH_PROJECT_API);
    }

    public static String getPerspectiveNameByID(String perspectiveID) {
        return perspectiveNameByID.get(perspectiveID);
    }

    public static String getPreferenceStoreKeyByPerspectiveID(String perspectiveID) {
        return preferenceStoreKeyByPerspectiveID.get(perspectiveID);
    }
}

