/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.OnPremStatusChanged;
import org.mule.tooling.core.auth.PlatformRegion;
import org.mule.tooling.core.auth.UpdateRegionServicesUrlsEvent;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.ui.authentication.AuthenticationActivator;
import org.mule.tooling.utils.eventbus.IEvent;

public class OnPremPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final IPreferenceStore PREFERENCE_STORE = AuthenticationActivator.getDefault().getPreferenceStore();
    private static final String[] LABELS = new String[]{"Update", "Cancel"};
    private static final String REGIONS_SETTINGS_LABEL = "Region Settings";
    private static final String ENABLE_ONPREM_DIALOG = "Use a Private Cloud Edition instance";
    private static final String ENABLE_HYPERFORCE_DIALOG = "Use this control plane";
    private static final String ONPREM_URL = "Private Cloud Instance URL";
    private static final String HYPEFORCE_URL = "Anypoint Platform URL";
    private Boolean addWarningChangedPceUrl = Boolean.FALSE;
    private Boolean addWarningChangedHyperforceUrl = Boolean.FALSE;
    private BooleanFieldEditor enablePceFieldEditor;
    private BooleanFieldEditor enableHyperforceFieldEditor;
    private StringFieldEditor pceUrlFieldEditor;
    private StringFieldEditor hyperforceUrlFieldEditor;
    private ComboFieldEditor regionCombo;
    private StringFieldEditor customRegion;
    private StringFieldEditor customMasterOrg;
    private Boolean addWarningChangedRegion = Boolean.FALSE;
    private Group regionGroup;
    private Group pceSettingsGroup;
    private Group hyperforceSettingsGroup;

    public OnPremPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PREFERENCE_STORE);
    }

    protected void createFieldEditors() {
        this.regionGroup = new Group(this.getFieldEditorParent(), 32);
        this.regionGroup.setText(REGIONS_SETTINGS_LABEL);
        String[][] regionOptions = new String[][]{{PlatformRegion.US.getName(), PlatformRegion.US.getName()}, {PlatformRegion.EU.getName(), PlatformRegion.EU.getName()}, {PlatformRegion.GOV.getName(), PlatformRegion.GOV.getName()}, {"Other", "Other"}};
        this.regionCombo = new ComboFieldEditor("org.mule.tooling.core.region", "Select your region", regionOptions, (Composite)this.regionGroup);
        this.customRegion = new StringFieldEditor("org.mule.tooling.core.custom.region", "Custom region", (Composite)this.regionGroup){

            public void setEnabled(boolean enabled, Composite parent) {
                super.setEnabled(enabled, parent);
                OnPremPreferencePage.this.enableCustomLabelText(this.getLabelControl(), enabled);
                this.refreshValidState();
            }
        };
        this.customMasterOrg = new StringFieldEditor("org.mule.tooling.core.custom.master.org", "Custom Master Organization ID", (Composite)this.regionGroup){

            public void setEnabled(boolean enabled, Composite parent) {
                super.setEnabled(enabled, parent);
                OnPremPreferencePage.this.enableCustomLabelText(this.getLabelControl(), enabled);
                this.refreshValidState();
            }
        };
        this.pceSettingsGroup = new Group(this.getFieldEditorParent(), 32);
        this.pceSettingsGroup.setText("PCE Settings");
        this.enablePceFieldEditor = new BooleanFieldEditor("org.mule.tooling.onprem.enabled", ENABLE_ONPREM_DIALOG, (Composite)this.pceSettingsGroup){

            protected void doStore() {
                super.doStore();
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new OnPremStatusChanged(this.getBooleanValue(), this.getPreferenceStore().getString("org.mule.tooling.onprem.url")));
            }
        };
        this.pceUrlFieldEditor = new StringFieldEditor("org.mule.tooling.onprem.url", ONPREM_URL, (Composite)this.pceSettingsGroup){

            protected void doStore() {
                String trimmedUrl = OnPremPreferencePage.this.getTrimmedUrl(this.getTextControl());
                this.getPreferenceStore().setValue(this.getPreferenceName(), trimmedUrl);
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new OnPremStatusChanged(this.getPreferenceStore().getBoolean("org.mule.tooling.onprem.enabled"), trimmedUrl));
            }
        };
        this.hyperforceSettingsGroup = new Group(this.getFieldEditorParent(), 32);
        this.hyperforceSettingsGroup.setText("Control Plane Settings");
        this.enableHyperforceFieldEditor = new BooleanFieldEditor("org.mule.tooling.hyperforce.enabled", ENABLE_HYPERFORCE_DIALOG, (Composite)this.hyperforceSettingsGroup);
        this.hyperforceUrlFieldEditor = new StringFieldEditor("org.mule.tooling.hyperforce.url", HYPEFORCE_URL, (Composite)this.hyperforceSettingsGroup){

            protected void doStore() {
                this.getPreferenceStore().setValue(this.getPreferenceName(), OnPremPreferencePage.this.getTrimmedUrl(this.getTextControl()));
            }
        };
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.regionGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.pceSettingsGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.hyperforceSettingsGroup);
        this.addField((FieldEditor)this.enablePceFieldEditor);
        this.addField((FieldEditor)this.enableHyperforceFieldEditor);
        this.addField((FieldEditor)this.pceUrlFieldEditor);
        this.addField((FieldEditor)this.hyperforceUrlFieldEditor);
        this.addField((FieldEditor)this.regionCombo);
        this.addField((FieldEditor)this.customRegion);
        this.addField((FieldEditor)this.customMasterOrg);
    }

    protected void initialize() {
        super.initialize();
        boolean pceEnabled = PREFERENCE_STORE.getBoolean("org.mule.tooling.onprem.enabled");
        boolean hyperforceEnabled = PREFERENCE_STORE.getBoolean("org.mule.tooling.hyperforce.enabled");
        this.updateGroupsState(pceEnabled, hyperforceEnabled);
        this.enablePceFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Boolean newValue;
                OnPremPreferencePage.this.addWarningChangedPceUrl = newValue = (Boolean)event.getNewValue();
                OnPremPreferencePage.this.updateGroupsState(newValue, false);
            }
        });
        this.pceUrlFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                OnPremPreferencePage.this.addWarningChangedPceUrl = Boolean.TRUE;
            }
        });
        this.regionCombo.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                OnPremPreferencePage.this.addWarningChangedRegion = Boolean.TRUE;
                String selectedRegion = (String)event.getNewValue();
                OnPremPreferencePage.this.updateCustomRegionFields("Other".equals(selectedRegion));
                OnPremPreferencePage.this.updateGroupsState(false, false);
            }
        });
        this.enableHyperforceFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Boolean newValue;
                OnPremPreferencePage.this.addWarningChangedHyperforceUrl = newValue = (Boolean)event.getNewValue();
                OnPremPreferencePage.this.updateGroupsState(false, newValue);
            }
        });
        this.hyperforceUrlFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                OnPremPreferencePage.this.addWarningChangedHyperforceUrl = Boolean.TRUE;
            }
        });
    }

    private String getTrimmedUrl(Text textControl) {
        char charAt;
        Object trimmedUrl = textControl.getText().trim();
        int length = ((String)trimmedUrl).length();
        if (length != 0 && (charAt = ((String)trimmedUrl).charAt(length - 1)) != '/') {
            trimmedUrl = (String)trimmedUrl + "/";
        }
        return trimmedUrl;
    }

    private void updateGroupsState(Boolean isPceEnabled, Boolean isHyperforceEnabled) {
        this.updateFieldEditorsBasedOnSelection(isPceEnabled, isHyperforceEnabled);
        this.enablePceComponent(isPceEnabled);
        this.enableHyperforceComponent(isHyperforceEnabled);
        Boolean enableRegion = isPceEnabled == false && isHyperforceEnabled == false;
        this.enableRegionControls(enableRegion);
    }

    private void updateFieldEditorsBasedOnSelection(Boolean isPceEnabled, Boolean isHyperforceEnabled) {
        if (isPceEnabled.booleanValue()) {
            this.enableHyperforceFieldEditor.loadDefault();
        }
        if (isHyperforceEnabled.booleanValue()) {
            this.enablePceFieldEditor.loadDefault();
        }
    }

    private void enablePceComponent(Boolean value) {
        if (value.booleanValue()) {
            this.pceUrlFieldEditor.getTextControl((Composite)this.pceSettingsGroup).setText(this.getPreferenceStore().getString("org.mule.tooling.onprem.url"));
        } else {
            this.pceUrlFieldEditor.getTextControl((Composite)this.pceSettingsGroup).setText("https://anypoint.mulesoft.com/");
        }
        this.pceUrlFieldEditor.setEnabled(value.booleanValue(), (Composite)this.pceSettingsGroup);
    }

    private void enableHyperforceComponent(Boolean value) {
        if (value.booleanValue()) {
            this.hyperforceUrlFieldEditor.getTextControl((Composite)this.hyperforceSettingsGroup).setText(this.getPreferenceStore().getString("org.mule.tooling.hyperforce.url"));
        } else {
            this.hyperforceUrlFieldEditor.getTextControl((Composite)this.hyperforceSettingsGroup).setText("https://platform.mulesoft.com/");
        }
        this.hyperforceUrlFieldEditor.setEnabled(value.booleanValue(), (Composite)this.hyperforceSettingsGroup);
    }

    private void enableRegionControls(Boolean value) {
        this.regionGroup.setEnabled(value.booleanValue());
        this.enableCustomLabelText(this.regionCombo.getLabelControl((Composite)this.regionGroup), value);
        this.enableCustomLabelText(this.customRegion.getLabelControl((Composite)this.regionGroup), value);
        this.enableCustomLabelText(this.customMasterOrg.getLabelControl((Composite)this.regionGroup), value);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enablePceComponent(false);
        this.updateCustomRegionFields(false);
    }

    private void undoChanges() {
        String currentRegion = this.getPreferenceStore().getString("org.mule.tooling.core.region");
        String currentCustomRegion = this.getPreferenceStore().getString("org.mule.tooling.core.custom.region");
        String currentCustomMasterOrg = this.getPreferenceStore().getString("org.mule.tooling.core.custom.master.org");
        if (currentCustomMasterOrg == null || currentCustomRegion == null || currentRegion == null) {
            this.performDefaults();
        } else {
            this.regionCombo.getPreferenceStore().setValue("org.mule.tooling.core.region", currentRegion);
            this.customMasterOrg.setStringValue(currentCustomMasterOrg);
            this.customRegion.setStringValue(currentCustomRegion);
        }
        this.regionCombo.load();
        this.customMasterOrg.load();
        this.customMasterOrg.load();
        this.updateCustomRegionFields("Other".equals(currentRegion));
    }

    protected void updateCustomRegionFields(Boolean enable) {
        this.customRegion.setEmptyStringAllowed(enable == false);
        this.customMasterOrg.setEmptyStringAllowed(enable == false);
        this.customRegion.setEnabled(enable.booleanValue(), (Composite)this.regionGroup);
        this.customMasterOrg.setEnabled(enable.booleanValue(), (Composite)this.regionGroup);
        this.setValid(enable == false);
        if (enable.booleanValue()) {
            Boolean emptyValues = this.customMasterOrg.getStringValue().isEmpty() || this.customRegion.getStringValue().isEmpty();
            this.setValid(emptyValues == false);
        }
    }

    protected void enableCustomLabelText(Label label, boolean enabled) {
        label.setEnabled(enabled);
    }

    public boolean performOk() {
        boolean enablePce = this.enablePceFieldEditor.getBooleanValue();
        boolean enableHyperforce = this.enableHyperforceFieldEditor.getBooleanValue();
        Shell activeShell = Display.getDefault().getActiveShell();
        if (this.addWarningChangedRegion.booleanValue()) {
            return this.performChangeRegionChanges(activeShell);
        }
        if (enablePce && this.addWarningChangedPceUrl.booleanValue()) {
            return this.performEnablePceInstanceChange(activeShell);
        }
        if (enableHyperforce && this.addWarningChangedHyperforceUrl.booleanValue()) {
            return this.performEnableHyperforceInstanceChange(activeShell);
        }
        this.setEnableApiDependenciesPreference();
        return super.performOk();
    }

    private boolean performEnablePceInstanceChange(Shell activeShell) {
        this.addWarningChangedPceUrl = Boolean.FALSE;
        MessageDialog messageDialog = new MessageDialog(activeShell, "Change Anypoint Platform URL", null, "Changing this URL will not change your existing projects settings. If you already have projects created you need to modify your projects POM files to point to this PCE instance URL. Besides, you must login to the Anypoint Platform again.", 4, LABELS, 0);
        int result = messageDialog.open();
        if (result == 0) {
            this.setEnableApiDependenciesPreference();
            return super.performOk();
        }
        this.addWarningChangedPceUrl = Boolean.TRUE;
        return false;
    }

    private void setEnableApiDependenciesPreference() {
        boolean pceEnabled = this.enablePceFieldEditor.getBooleanValue();
        IEclipsePreferences eclipsePreferenceStore = LoginManager.getPreferences();
        if (pceEnabled) {
            boolean enableApiDependenciesManagement;
            try {
                enableApiDependenciesManagement = this.pceInstanceHasExchangeMavenFacadeV2();
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)"It was not possible to connect to PCE endpoint", (Throwable)e);
                enableApiDependenciesManagement = true;
            }
            if (enableApiDependenciesManagement) {
                eclipsePreferenceStore.putBoolean("org.mule.tooling.ui.properties.enable.api.dependencies", true);
                this.sendExchangeMavenFacadeVersion("V2");
            } else {
                eclipsePreferenceStore.putBoolean("org.mule.tooling.ui.properties.enable.api.dependencies", false);
                this.sendExchangeMavenFacadeVersion("V1");
            }
        } else {
            eclipsePreferenceStore.putBoolean("org.mule.tooling.ui.properties.enable.api.dependencies", true);
        }
    }

    private void sendExchangeMavenFacadeVersion(String version) {
        AnalyticsRecordsFactory.single((String)Events.PRIVATE_CLOUD_EDITION_CONFIGURED, (String[])new String[]{"version", version}).track();
    }

    private boolean pceInstanceHasExchangeMavenFacadeV2() throws IOException {
        ConnectionManager connectionManager = (ConnectionManager)EclipseContextHelper.getFromStudioContext(ConnectionManager.class);
        String activePlatformUrl = this.pceUrlFieldEditor.getStringValue();
        CloseableHttpClient restClient = connectionManager.createApacheClientForUri(URI.create(activePlatformUrl));
        HttpUriRequest request = RequestBuilder.get().setUri(activePlatformUrl + "/exchange/maven/api/v2/ping").build();
        CloseableHttpResponse response = null;
        response = restClient.execute(request);
        int responseStatusCode = response.getStatusLine().getStatusCode();
        return responseStatusCode == 401 || responseStatusCode == 200;
    }

    private boolean performChangeRegionChanges(Shell activeShell) {
        this.addWarningChangedRegion = Boolean.FALSE;
        MessageDialog messageDialog = new MessageDialog(activeShell, "Change region configuration", null, "Once the region is changed all the stored users in studio preferences will be deleted", 2, LABELS, 0);
        int result = messageDialog.open();
        if (result == 0) {
            this.setEnableApiDependenciesPreference();
            boolean performOk = super.performOk();
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new UpdateRegionServicesUrlsEvent());
            CoreUtils.getLoginManager().removeAllUsers();
            return performOk;
        }
        this.addWarningChangedRegion = Boolean.TRUE;
        this.undoChanges();
        return false;
    }

    private boolean performEnableHyperforceInstanceChange(Shell activeShell) {
        this.addWarningChangedHyperforceUrl = Boolean.FALSE;
        MessageDialog messageDialog = new MessageDialog(activeShell, "Change Anypoint Platform URL", null, "Changing this URL will not change your existing projects settings. If you already have projects created you need to modify your projects POM files to point to this Hyperforce instance URL. Besides, you must login to the Anypoint Platform again.", 4, LABELS, 0);
        int result = messageDialog.open();
        if (result == 0) {
            this.setEnableApiDependenciesPreference();
            boolean performOk = super.performOk();
            CoreUtils.getLoginManager().removeAllUsers();
            return performOk;
        }
        this.addWarningChangedHyperforceUrl = Boolean.TRUE;
        return false;
    }
}

