/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;

public class MuleStudioPreferencesInitializer
extends AbstractPreferenceInitializer {
    private static final String WST_XML_PLUGIN = "org.eclipse.wst.xml.core.xml";

    public void initializeDefaultPreferences() {
        IPreferenceStore store = MuleUIPlugin.getDefault().getPreferenceStore();
        store.setDefault("beta_agreement_choice", false);
        store.setDefault("no_validation_xsd_xml", true);
        store.setDefault("no_parsing_xml", false);
        store.setDefault("create_git_ignore", true);
        store.setDefault("palette_tool_tips", true);
        store.setDefault("datasense.levels.recursion", 1);
        store.setDefault("datasense.timeout", 180);
        store.setDefault("use_new_launcher", false);
        store.setDefault("new_launcher_agent_port", 9999);
        store.setDefault("warn_server_mismatch_at_launch", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        store.setDefault("replace_doc_id_when_paste", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        store.setDefault("show_mule_properties_view_on_selection", true);
        store.setDefault("max_config_filesize", 0x100000);
        store.setDefault("add_exchange_repositories_to pom", true);
        store.setDefault("studio.perspective.switch.project.mule", "prompt");
        store.setDefault("studio.perspective.switch.project.api", "prompt");
        store.setDefault("studio.perspective.switch.project.java", "prompt");
        store.setDefault("show_selection_api_on_new_project", true);
        store.setDefault("add_suffix_to_cloned_entities", true);
        store.setDefault("enable_fips_support", false);
        store.setDefault("update_runtime_version_in_mule_artifact", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        boolean defaultIfNotPresent = LoginManager.getPreferences().getBoolean("org.mule.tooling.ui.properties.enable.api.dependencies", true);
        LoginManager.getPreferences().putBoolean("org.mule.tooling.ui.properties.enable.api.dependencies", defaultIfNotPresent);
        this.initializeXmlPreferences();
    }

    private void initializeXmlPreferences() {
        try {
            Validator[] vals;
            ValidationFramework vf = ValidationFramework.getDefault();
            Validator[] validatorArray = vals = vf.getValidators();
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                if (WST_XML_PLUGIN.equals(v.getId())) {
                    v.setBuildValidation(false);
                    v.setManualValidation(false);
                }
                ++n2;
            }
            vf.saveValidators(vals);
        }
        catch (InvocationTargetException e) {
            MuleCorePlugin.logError((String)"Cannot set default xml validation preferences", (Throwable)e);
        }
    }

    public static String getDefaultRuntimeId() {
        ArrayList serverDefinitions = new ArrayList(MuleCorePlugin.getServerManager().getServerDefinitions());
        Collections.sort(serverDefinitions);
        Collections.reverse(serverDefinitions);
        IServerDefinition defaultRuntime = (IServerDefinition)serverDefinitions.get(0);
        return defaultRuntime.getId();
    }
}

