/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.ui.MuleUIPlugin;

public class MuleStudioPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CONVERT_INBOUND_TO_OUTBOUND = "endopoint.convert_inbound_to_outbound";
    public static final String EXPERIMENT_DATA_MAPPER_IN_CE_ASK = "experiment_data_mapper_in_ce_ask";
    public static final String CANNOT_MOVE_MESSAGE_SOURCE_TO_OUTBOUND = "message_source_cannot_be_moved_inform";
    public static final String NO_VALIDATION_IN_XML = "no_validation_xml";
    public static final String OUTPUT_OPERATION_RE_TYPE = "output_operation_re_type";
    public static final String CREATE_GIT_IGNORE = "create_git_ignore";
    public static final String NO_XSD_VALIDATION_IN_XML = "no_validation_xsd_xml";
    public static final String NO_XML_PARSING_IN_XML = "no_parsing_xml";
    public static final String PROPERTIES_ON_DOUBLE_CLICK = "properties_on_double_click";
    public static final String CHECK_MULE_SERVER_ALREADY_RUNNING = "server_already_running_inform";
    public static final String ENABLE_ANALYTICS = "enable_analytics";
    public static final String USE_NEW_LAUNCHER = "use_new_launcher";
    public static final String NEW_LAUNCHER_AGENT_PORT = "new_launcher_agent_port";
    public static final String WARN_SERVER_MISMATCH_AT_LAUNCH = "warn_server_mismatch_at_launch";
    public static final String BETA_AGREEMENT = "beta_agreement_choice";
    public static final String PALETTE_INVERTED = "palette_inverted";
    public static final String PALETTE_TOOL_TIPS = "palette_tool_tips";
    public static final String REPLACE_DOC_ID = "replace_doc_id_when_paste";
    public static final String SHOW_MULE_PROPERTIES_VIEW_ON_SELECTION = "show_mule_properties_view_on_selection";
    public static final String ALLWAYS_REPLACE_READER_PROPERTIES = "allways_replace_reader_properties";
    public static final String ADD_EXCHANGE_REPOSITORIES_TO_POM = "add_exchange_repositories_to pom";
    public static final String SHOW_SELECTION_API_IN_NEW_PROJECT = "show_selection_api_on_new_project";
    public static final String ADD_SUFFIX_TO_CLONED_ENTITIES = "add_suffix_to_cloned_entities";
    public static final String UPDATE_RUNTIME_VERSION_IN_MULE_ARTIFACT = "update_runtime_version_in_mule_artifact";

    public MuleStudioPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(MuleUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Set the message flow general preferences.");
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(NO_VALIDATION_IN_XML, "&Turn off error reporting in XML editor", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(OUTPUT_OPERATION_RE_TYPE, "&Enable Output Operation Re-Typing (Needs to delete cache after this)", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(NO_XML_PARSING_IN_XML, "&Turn off xml well-formedness validation in XML editor", this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor(CHECK_MULE_SERVER_ALREADY_RUNNING, "&Always run another instance of the embedded Mule runtime", 3, (String[][])new String[][]{{"Prompt", ActionDialogState.PROMPT.name()}, {"Always", ActionDialogState.ALWAYS.name()}, {"Never", ActionDialogState.NEVER.name()}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(UPDATE_RUNTIME_VERSION_IN_MULE_ARTIFACT, "&Update Runtime version in mule-artifact.json", 3, (String[][])new String[][]{{"Prompt", ActionDialogState.PROMPT.name()}, {"Always", ActionDialogState.ALWAYS.name()}, {"Never", ActionDialogState.NEVER.name()}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(WARN_SERVER_MISMATCH_AT_LAUNCH, "&Warn user of server mismatch when launching", 3, (String[][])new String[][]{{"Prompt", ActionDialogState.PROMPT.name()}, {"Never", ActionDialogState.NEVER.name()}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new BooleanFieldEditor(CREATE_GIT_IGNORE, "&Create .gitignore on Mule project creation", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(PALETTE_INVERTED, "&Invert Palette panes", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(PALETTE_TOOL_TIPS, "&Show Palette tool tips", this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor(REPLACE_DOC_ID, "&Replace doc:id values when pasting XML in text view", 3, (String[][])new String[][]{{"Prompt", ActionDialogState.PROMPT.name()}, {"Always", ActionDialogState.ALWAYS.name()}, {"Never", ActionDialogState.NEVER.name()}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new BooleanFieldEditor(SHOW_MULE_PROPERTIES_VIEW_ON_SELECTION, "&Show Mule Properties View when selecting an element", this.getFieldEditorParent()));
        IntegerFieldEditor maxFileSizeEditor = new IntegerFieldEditor("max_config_filesize", "Max file size to parse models from configuration files (in bytes)", this.getFieldEditorParent());
        maxFileSizeEditor.setValidRange(8096, 0xA00000);
        this.addField((FieldEditor)maxFileSizeEditor);
        this.addField((FieldEditor)new BooleanFieldEditor(ADD_EXCHANGE_REPOSITORIES_TO_POM, "&Add Exchange repositories to pom.xml", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(SHOW_SELECTION_API_IN_NEW_PROJECT, "&Show menu to add APIs when creating a New Project", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(ADD_SUFFIX_TO_CLONED_ENTITIES, "&Add numeric suffix to copy-pasted flow entities", this.getFieldEditorParent()));
    }

    public boolean performOk() {
        boolean boolean1 = this.getPreferenceStore().getBoolean(NO_VALIDATION_IN_XML);
        boolean performOk = super.performOk();
        boolean boolean2 = this.getPreferenceStore().getBoolean(NO_VALIDATION_IN_XML);
        if (boolean1 != boolean2) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    if (MuleRuntime.create((IProject)p) != null) {
                        p.build(15, (IProgressMonitor)new NullProgressMonitor());
                        p.build(6, (IProgressMonitor)new NullProgressMonitor());
                    }
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activeWorkbenchWindow.getShell().setRedraw(false);
                    try {
                        IEditorReference[] editorReferences;
                        IEditorReference[] iEditorReferenceArray = editorReferences = activeWorkbenchWindow.getActivePage().getEditorReferences();
                        int n3 = editorReferences.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            FormEditor f;
                            IEditorPart activeEditor;
                            IEditorReference r = iEditorReferenceArray[n4];
                            IEditorPart editor = r.getEditor(false);
                            if (editor != null && editor instanceof FormEditor && (activeEditor = (f = (FormEditor)editor).getActiveEditor()) instanceof StatusTextEditor) {
                                StatusTextEditor ra = (StatusTextEditor)activeEditor;
                                boolean q = ra.isDirty();
                                IDocument document = ra.getDocumentProvider().getDocument((Object)ra.getEditorInput());
                                String string = document.get();
                                ISelection selection = ra.getSelectionProvider().getSelection();
                                document.set("");
                                document.set(string);
                                ra.getSelectionProvider().setSelection(selection);
                                if (!q) {
                                    ra.doSave((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            ++n4;
                        }
                    }
                    finally {
                        activeWorkbenchWindow.getShell().setRedraw(true);
                    }
                }
                catch (Exception e) {
                    MuleCorePlugin.getLog().log((IStatus)new Status(4, "org.mule.tooling.core", e.getMessage(), (Throwable)e));
                }
                ++n2;
            }
        }
        return performOk;
    }

    public static enum ActionDialogState {
        ALWAYS,
        NEVER,
        PROMPT;


        public static ActionDialogState fromPreference(IPreferenceStore store, String key) {
            String propValue = store.getString(key);
            if (propValue == null || propValue.isEmpty()) {
                return PROMPT;
            }
            return ActionDialogState.valueOf(propValue);
        }

        public boolean prompt() {
            return this == PROMPT;
        }

        public boolean isAlways() {
            return this == ALWAYS;
        }
    }
}

