/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;
import org.mule.tooling.ui.preferences.MuleStudioPreferencesInitializer;

public class MuleStudioPreference {
    public int getDatasenseLevelsOfRecursion() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getInt("datasense.levels.recursion");
    }

    public static int getDatasenseTimeoutInSeconds() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getInt("datasense.timeout");
    }

    public IServerDefinition getDefaultRuntimeSelection() {
        String defaultRuntimeSelectionId = this.getDefaultRuntimeSelectionId();
        IServerDefinition defaultServerDefinition = MuleCorePlugin.getServerManager().getServerDefinition(defaultRuntimeSelectionId);
        if (defaultServerDefinition == null) {
            String defaultRuntimeId = MuleStudioPreferencesInitializer.getDefaultRuntimeId();
            IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
            preferenceStore.setDefault("default_mule_runtime_selection", defaultRuntimeId);
            preferenceStore.setToDefault("default_mule_runtime_selection");
            defaultServerDefinition = MuleCorePlugin.getServerManager().getServerDefinition(defaultRuntimeId);
        }
        return defaultServerDefinition;
    }

    public String getDefaultRuntimeSelectionId() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getString("default_mule_runtime_selection");
    }

    public boolean shouldWarnUserOfServerMismatch() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getString("warn_server_mismatch_at_launch").equals(MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
    }

    public boolean isPaletteInverted() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("palette_inverted");
    }

    public boolean showPaletteToolTips() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("palette_tool_tips");
    }
}

