/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryExtension;
import org.mule.tooling.ui.preferences.Messages;
import org.mule.tooling.utils.OsDetect;
import org.osgi.service.prefs.BackingStoreException;

public class InstallationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String CLEAN = "Clean";
    private static final String WINDOWS_DEFENDER_DESCRIPTION = "Clean Windows Defender real time scanning decision made.";
    private static final String WINDOWS_DEFENDER_NOTIFICATION_DIALOG = "Studio will prompt again on the next startup.";

    public InstallationPreferencePage() {
    }

    public InstallationPreferencePage(String title) {
        super(title);
    }

    public InstallationPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)MuleCorePlugin.getScopedPreferenceStore());
        this.setDescription(Messages.INSTALLATION_DESCRIPTION);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createUICacheSection(composite);
        this.setControl((Control)parent);
        return parent;
    }

    private void createUICacheSection(Composite parent) {
        Group dependenciesGroup = new Group(parent, 32);
        Label description = new Label((Composite)dependenciesGroup, 0);
        description.setText(Messages.RESET_LABEL_DESCRIPTION);
        Button reset = new Button((Composite)dependenciesGroup, 0);
        reset.setText(Messages.RESET_BUTTON_LABEL);
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userAcceptsTerms = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)Messages.CONFIRM_USER_MESSAGE);
                if (userAcceptsTerms) {
                    MavenRepositoryExtension.clearMavenRepositoryInstallationInfo();
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
        if (OsDetect.isWindows()) {
            Label descriptionDefender = new Label((Composite)dependenciesGroup, 0);
            descriptionDefender.setText(WINDOWS_DEFENDER_DESCRIPTION);
            Button clean = new Button((Composite)dependenciesGroup, 0);
            clean.setText(CLEAN);
            clean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.mule.tooling.core.windowsdefender");
                    preferences.putBoolean("org.mule.tooling.core.windowsdefender", false);
                    try {
                        preferences.flush();
                        MessageDialog.openInformation((Shell)InstallationPreferencePage.this.getShell(), (String)"Windows Defender", (String)InstallationPreferencePage.WINDOWS_DEFENDER_NOTIFICATION_DIALOG);
                    }
                    catch (BackingStoreException ex) {
                        MuleCorePlugin.logError((String)"Failed to save the Windows Defender information to the configuration preference", (Throwable)ex);
                    }
                }
            });
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)clean);
            GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)descriptionDefender);
        }
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)reset);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)description);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)dependenciesGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dependenciesGroup);
    }
}

