/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.muleimports;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.mule.tooling.core.utils.CoreUtils;

public class ImportItemsDeleter
extends ContributionItem {
    public void fill(Menu menu, int index) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            if (this.isImportItem(menuItem)) {
                this.removeItem(menuItem);
                break;
            }
            ++n2;
        }
    }

    private void removeItem(final MenuItem menuItem) {
        final MenuManager menuManager = (MenuManager)this.getParent();
        this.hideItemFromMenu(menuManager, menuItem);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (CoreUtils.isToolingPerspective()) {
                    ImportItemsDeleter.this.hideItemFromMenu(menuManager, menuItem);
                }
            }
        });
    }

    private void hideItemFromMenu(MenuManager menuManager, MenuItem menuItem) {
        String[] items;
        String[] stringArray = items = new String[]{"import", "export"};
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String itemName = stringArray[n2];
            IContributionItem remove = menuManager.remove(itemName);
            if (remove != null) {
                remove.setVisible(false);
            }
            ++n2;
        }
        menuManager.update(true);
        IContributionManager parent = menuManager.getParent();
        if (parent != null) {
            parent.update(true);
        }
    }

    private boolean isImportItem(MenuItem menuItem) {
        Object data = menuItem.getData();
        if (data instanceof ActionContributionItem) {
            ActionContributionItem contribution = (ActionContributionItem)data;
            IAction action = contribution.getAction();
            boolean isImportAction = action != null && action instanceof ImportResourcesAction;
            return isImportAction;
        }
        return false;
    }
}

