/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.ui.m2.dependency.MavenDependencyChangeListener;

public class ObservableMavenDependency
implements MavenDependency {
    private List<MavenDependencyChangeListener> listeners = new ArrayList<MavenDependencyChangeListener>();
    private PojoMavenDependency dependency = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withScope(MavenDependency.Scope.COMPILE)).withType("jar")).build();

    public void setArtifactId(String artifactId) {
        String previous = this.dependency.getArtifactId();
        if (previous == null || !previous.equals(artifactId)) {
            this.dependency.setArtifactId(artifactId);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.artifactIdChanged(this, previous, artifactId);
            }
        }
    }

    public void setGroupId(String groupId) {
        String previous = this.dependency.getGroupId();
        if (previous == null || !previous.equals(groupId)) {
            this.dependency.setGroupId(groupId);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.groupIdChanged(this, previous, groupId);
            }
        }
    }

    public void setVersion(String version) {
        String previous = this.dependency.getVersion();
        if (previous == null || !previous.equals(version)) {
            this.dependency.setVersion(version);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.versionChanged(this, previous, version);
            }
        }
    }

    public void setScope(MavenDependency.Scope scope) {
        MavenDependency.Scope previous = this.dependency.getScope();
        if (previous == null || !previous.equals((Object)scope)) {
            this.dependency.setScope(scope);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.scopeChanged(this, previous, scope);
            }
        }
    }

    public void setClassifier(String classifier) {
        Optional previous = this.dependency.getClassifier();
        if (!previous.isPresent() || !((String)previous.get()).equals(classifier)) {
            this.dependency.setClassifier(classifier);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.classifierChanged(this, previous.orElse(null), classifier);
            }
        }
    }

    public void setType(String type) {
        Optional previous = this.dependency.getType();
        if (!previous.isPresent() || !((String)previous.get()).equals(type)) {
            this.dependency.setType(type);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.typeChanged(this, previous.orElse(null), type);
            }
        }
    }

    public void setSystemPath(String systemPath) {
        Optional previous = this.dependency.getSystemPath();
        if (!previous.isPresent() || !((String)previous.get()).equals(systemPath)) {
            this.dependency.setSystemPath(systemPath);
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.systemPathChanged(this, previous.orElse(null), systemPath);
            }
        }
    }

    public void setOptional(boolean optional) {
        Optional previous = this.dependency.isOptional();
        if (!previous.isPresent() || !((Boolean)previous.get()).equals(optional)) {
            this.dependency.setOptional(Boolean.valueOf(optional));
            for (MavenDependencyChangeListener listener : this.listeners) {
                listener.optionalChanged(this, previous.orElse(null), optional);
            }
        }
    }

    public String getGroupId() {
        return this.dependency.getGroupId();
    }

    public String getArtifactId() {
        return this.dependency.getArtifactId();
    }

    public String getVersion() {
        return this.dependency.getVersion();
    }

    public MavenDependency.Scope getScope() {
        return this.dependency.getScope();
    }

    public Optional<String> getClassifier() {
        return this.dependency.getClassifier();
    }

    public Optional<String> getType() {
        return this.dependency.getType();
    }

    public Optional<String> getSystemPath() {
        return this.dependency.getSystemPath();
    }

    public Optional<Boolean> isOptional() {
        return this.dependency.isOptional();
    }

    public void addDependencyChangeListener(MavenDependencyChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean isSharedDependency() {
        return this.dependency.isSharedDependency();
    }
}

