/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.MavenDependencyXmlParser;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.query.MavenSearchEngine;
import org.mule.tooling.ui.command.InstallArtifact;
import org.mule.tooling.ui.m2.dependency.MavenArtifactSearchComponent;
import org.mule.tooling.ui.m2.dependency.MavenDependencyChangeAdapter;
import org.mule.tooling.ui.m2.dependency.MavenDependencyChangeListener;
import org.mule.tooling.ui.m2.dependency.MavenDependencyPickerListener;
import org.mule.tooling.ui.m2.dependency.ObservableMavenDependency;
import org.mule.tooling.ui.widgets.script.SharedColors;
import org.mule.tooling.ui.widgets.search.SearchTextField;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MavenDependencyPicker {
    private static final String ARTIFACT_DEFINITION = "Artifact Definition";
    private static final String INSTALL_DEPENDENCY_MESSAGE = "Install a local dependency";
    private static final String INSTALL_BUTTON_LABEL = "Install";
    private static final String INSTALL_INFO_TEXT = "You can use this option if you don't have access to the internet or\nif you have a file that was not built with maven and you need to make\nit available as a dependency";
    private static final String ADVANCED_SETTINGS = "Advanced settings";
    private static final String OPTIONAL_DEPENDENCY = "Optional dependency";
    private static final String SYSTEM_PATH = "System path";
    private static final String TYPE = "Type";
    private static final String SCOPE = "Scope";
    private static final String CLASSIFIER = "Classifier";
    private static final String VERSION = "Version";
    private static final String ARTIFACT_ID = "Artifact id";
    private static final String GROUP_ID = "Group id";
    private MavenDependency.Scope defaultScope = MavenDependency.Scope.COMPILE;
    private String defaultType = "jar";
    private String defaultClassifier = "";
    private String defaultArtifact = "some-artifact";
    private String defaultGroupId = "org.mycompany";
    private String defaultVersion = "1.0.0";
    private boolean allowsClassifierChange = true;
    private boolean allowsTypeChange = true;
    private List<MavenSearchEngine> searchEngines;
    private ObservableMavenDependency mavenDependency;
    private StackLayout stackLayout;
    private Composite stackingComposite;
    private Composite definitionComposite;
    private Composite searchComposite;
    private IStructuredDocument document;
    private Text groupIdField;
    private Text artifactIdField;
    private Text versionField;
    private Text typeField;
    private Text classifierField;
    private ComboViewer scopeField;
    private Text systemPathField;
    private Button optionalCheckbox;
    private DefinitionFieldsListener definitionFieldsListener;
    private SnippetDocumentListener snippetDocumentListener;
    private FieldsMavenDependencyListener fieldsMavenDependencyListener;
    private SnippetMavenDependencyListener snippetMavenDependencyListener;
    private IRunnableContext runnableContext;
    private boolean searching;
    private MavenArtifactSearchComponent mavenArtifactSearchComponent;

    private MavenDependencyPicker(IRunnableContext runnableContext, List<MavenSearchEngine> searchEngines) {
        this.runnableContext = runnableContext;
        this.searchEngines = searchEngines;
    }

    private MavenDependencyPicker() {
        this.searchEngines = Collections.emptyList();
    }

    public static MavenDependencyPicker create(Optional<List<MavenSearchEngine>> searchEngines, IRunnableContext runnableContext) {
        if (searchEngines != null && searchEngines.isPresent() && !searchEngines.get().isEmpty()) {
            return new MavenDependencyPicker(runnableContext, searchEngines.get());
        }
        return new MavenDependencyPicker();
    }

    public void addListener(final MavenDependencyPickerListener listener) {
        this.mavenDependency.addDependencyChangeListener(new MavenDependencyChangeAdapter(){

            @Override
            protected void defaultChange(MavenDependency dependency, Object previous, Object actual) {
                listener.dependencyChanged(dependency);
            }
        });
        this.mavenArtifactSearchComponent.addSearchListener(listener);
    }

    public void addMavenDependencyListener(MavenDependencyChangeListener listener) {
        this.mavenDependency.addDependencyChangeListener(listener);
    }

    public Control createControl(Composite parent) {
        Text searchTextField;
        this.mavenDependency = new ObservableMavenDependency();
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(LayoutConstants.getSpacing().x, (int)((double)LayoutConstants.getSpacing().y * 1.5)).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Text text = searchTextField = this.searchEngines.isEmpty() ? null : this.createSearchHeader(composite);
        if (!this.searchEngines.isEmpty()) {
            this.addSeparator(composite);
        }
        this.stackingComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.stackingComposite);
        this.stackLayout = new StackLayout();
        this.stackingComposite.setLayout((Layout)this.stackLayout);
        this.definitionComposite = this.createDefinitionComposite(this.stackingComposite);
        this.searchComposite = this.createSearchComposite(this.stackingComposite, searchTextField);
        this.revealDefinitionComposite();
        PojoMavenDependency defaultDependency = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(this.getDefaultGroupId())).withArtifactId(this.getDefaultArtifact())).withVersion(this.getDefaultVersion())).build();
        this.initializeDependency((MavenDependency)defaultDependency);
        return composite;
    }

    private void addSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridDataFactory.swtDefaults().span(2, 1).align(4, 0x1000000).applyTo((Control)separator);
    }

    private Text createSearchHeader(Composite composite) {
        if (this.searchEngines.isEmpty()) {
            return new Text(composite, 0);
        }
        Label link = new Label(composite, 0);
        link.setText("Search " + this.searchEngines.get(0).getName());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)link);
        SearchTextField searchTextField = new SearchTextField(composite, "Search");
        searchTextField.addModifyListener(new ModifyListener((Text)searchTextField){
            private final /* synthetic */ Text val$searchTextField;
            {
                this.val$searchTextField = text;
            }

            public void modifyText(ModifyEvent e) {
                MavenDependencyPicker.this.handleTextSearchModified(this.val$searchTextField);
            }
        });
        searchTextField.addTraverseListener(new TraverseListener((Text)searchTextField){
            private final /* synthetic */ Text val$searchTextField;
            {
                this.val$searchTextField = text;
            }

            public void keyTraversed(TraverseEvent event) {
                if (MavenDependencyPicker.this.hasPressedEnter(event)) {
                    MavenDependencyPicker.this.handleTextSearchModified(this.val$searchTextField);
                    event.doit = false;
                }
            }
        });
        searchTextField.setFocus();
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(-1, -1).applyTo((Control)searchTextField);
        return searchTextField;
    }

    private boolean hasPressedEnter(TraverseEvent e) {
        return e.keyCode == 13;
    }

    private void handleTextSearchModified(Text searchTextField) {
        if (!searchTextField.getText().isEmpty()) {
            this.revealSearchComposite();
        } else {
            this.revealDefinitionComposite();
        }
    }

    private Composite createSearchComposite(Composite stackingComposite, Text searchTextField) {
        if (this.searchEngines.isEmpty()) {
            return new Composite(stackingComposite, 0);
        }
        this.mavenArtifactSearchComponent = new MavenArtifactSearchComponent(this.runnableContext, this.searchEngines, searchTextField);
        Composite createControl = this.mavenArtifactSearchComponent.createControl(stackingComposite);
        this.mavenArtifactSearchComponent.addBackButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenDependencyPicker.this.revealDefinitionComposite();
            }
        });
        this.mavenArtifactSearchComponent.addEditButtonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional<MavenDependency> selectedDependency = MavenDependencyPicker.this.mavenArtifactSearchComponent.getSelectedDependency();
                if (selectedDependency.isPresent()) {
                    MavenDependencyPicker.this.initializeDependency(selectedDependency.get());
                    MavenDependencyPicker.this.revealDefinitionComposite();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)createControl);
        return createControl;
    }

    private void initializeDependency(MavenDependency dependency) {
        this.mavenDependency.setGroupId(dependency.getGroupId());
        this.mavenDependency.setArtifactId(dependency.getArtifactId());
        this.mavenDependency.setVersion(dependency.getVersion());
        this.mavenDependency.setScope(dependency.getScope());
        this.mavenDependency.setClassifier(dependency.getClassifier().orElse(null));
        this.mavenDependency.setType(dependency.getType().orElse(null));
        this.mavenDependency.setSystemPath(dependency.getSystemPath().orElse(null));
        this.mavenDependency.setOptional(dependency.isOptional().orElse(false));
    }

    public void setDependency(MavenDependency mavenDependency) {
        this.initializeDependency(mavenDependency);
    }

    private Composite createDefinitionComposite(Composite composite) {
        Composite definitionComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing((int)((double)LayoutConstants.getSpacing().x * 1.5), LayoutConstants.getSpacing().y).equalWidth(true).applyTo(definitionComposite);
        this.createParametersComposite(definitionComposite);
        this.createSnippetComposite(definitionComposite);
        this.createAdvancedComposite(definitionComposite);
        this.createInstallLocalComposite(definitionComposite);
        return definitionComposite;
    }

    private void revealSearchComposite() {
        this.searching = true;
        this.stackLayout.topControl = this.searchComposite;
        this.stackingComposite.layout();
    }

    private void revealDefinitionComposite() {
        this.searching = false;
        this.stackLayout.topControl = this.definitionComposite;
        this.stackingComposite.layout();
    }

    private void createAdvancedComposite(Composite definitionComposite) {
        Composite blank = new Composite(definitionComposite, 0);
        GridDataFactory.fillDefaults().grab(false, false).hint(-1, 10).applyTo((Control)blank);
        Group group = this.createGroupWithLabel(definitionComposite, ADVANCED_SETTINGS);
        String[] labels = new String[]{SCOPE, TYPE, CLASSIFIER, SYSTEM_PATH};
        int maxWidth = this.getMaxWidth((Control)group, labels);
        this.scopeField = this.initializeScopeField((Composite)group, maxWidth, SCOPE, this.getDefaultScope(), this.definitionFieldsListener);
        this.typeField = this.initializeTextField((Composite)group, maxWidth, TYPE, this.getDefaultType(), this.allowsTypeChange, this.definitionFieldsListener);
        this.classifierField = this.initializeTextField((Composite)group, maxWidth, CLASSIFIER, this.getDefaultClassifier(), this.allowsClassifierChange, this.definitionFieldsListener);
        this.systemPathField = this.initializeTextField((Composite)group, maxWidth, SYSTEM_PATH, "", this.definitionFieldsListener);
        this.optionalCheckbox = new Button((Composite)group, 32);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.optionalCheckbox);
        this.optionalCheckbox.setText(OPTIONAL_DEPENDENCY);
        this.optionalCheckbox.addSelectionListener((SelectionListener)this.definitionFieldsListener);
    }

    private Group createGroupWithLabel(Composite definitionComposite, String groupTest) {
        Group group = new Group(definitionComposite, 0);
        group.setText(groupTest);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).equalWidth(false).applyTo((Composite)group);
        return group;
    }

    private String getDefaultType() {
        return this.defaultType;
    }

    private MavenDependency.Scope getDefaultScope() {
        return this.defaultScope;
    }

    public MavenDependency getDependency() {
        if (this.searching && this.mavenArtifactSearchComponent.getSelectedDependency().isPresent()) {
            return this.mavenArtifactSearchComponent.getSelectedDependency().get();
        }
        return this.mavenDependency;
    }

    private void createSnippetComposite(Composite definitionComposite) {
        Composite composite = new Composite(definitionComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 3).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        CompositeRuler compositeRuler = new CompositeRuler();
        LineNumberChangeRulerColumn ruler = new LineNumberChangeRulerColumn((ISharedTextColors)new SharedColors());
        ruler.setBackground(ThemeUtils.getCurrentTheme().getBackgroundColor());
        ruler.setForeground(ThemeUtils.getCurrentTheme().getForegroundColor());
        compositeRuler.addDecorator(1, (IVerticalRulerColumn)ruler);
        Composite borderComposite = new Composite(composite, 2048);
        GridLayoutFactory.fillDefaults().applyTo(borderComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)borderComposite);
        StructuredTextViewer snippetViewer = new StructuredTextViewer(borderComposite, (IVerticalRuler)compositeRuler, null, false, 68354);
        this.document = StructuredModelManager.getModelManager().createStructuredDocumentFor(ContentTypeIdForXML.ContentTypeID_XML);
        snippetViewer.setDocument((IDocument)this.document);
        StructuredTextViewerConfigurationXML configuration = new StructuredTextViewerConfigurationXML();
        snippetViewer.configure((SourceViewerConfiguration)configuration);
        WidgetUtils.addUndoAndRedoCapability((TextViewer)snippetViewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(snippetViewer.getControl());
        this.snippetDocumentListener = new SnippetDocumentListener();
        this.document.addDocumentListener((IDocumentListener)this.snippetDocumentListener);
        this.snippetMavenDependencyListener = new SnippetMavenDependencyListener();
        this.mavenDependency.addDependencyChangeListener(this.snippetMavenDependencyListener);
        ThemeUtils.setCssId((Object)composite, (String)"mavenDependencyPicker");
    }

    protected void updateSnippet() {
        this.snippetDocumentListener.disable();
        boolean isCompile = this.mavenDependency.getScope() != null && this.mavenDependency.getScope().equals((Object)MavenDependency.Scope.COMPILE);
        boolean isOptional = this.mavenDependency.isOptional().isPresent() && this.mavenDependency.isOptional().get() != false;
        this.document.set("<dependency>\n" + this.xmlTagOrEmpty("groupId", this.mavenDependency.getGroupId()) + this.xmlTagOrEmpty("artifactId", this.mavenDependency.getArtifactId()) + this.xmlTagOrEmpty("version", this.mavenDependency.getVersion()) + (!isCompile && this.mavenDependency.getScope() != null ? this.xmlTag("scope", this.mavenDependency.getScope().asString()) : "") + this.xmlTagOrEmpty("type", this.mavenDependency.getType().orElse(null)) + this.xmlTagOrEmpty("classifier", this.mavenDependency.getClassifier().orElse(null)) + this.xmlTagOrEmpty("systemPath", this.mavenDependency.getSystemPath().orElse(null)) + (isOptional ? this.xmlTag("optional", "true") : "") + "</dependency>");
        this.snippetDocumentListener.enable();
    }

    private String xmlTagOrEmpty(String tag, String value) {
        return StringUtils.isNotBlank((String)value) ? this.xmlTag(tag, value) : "";
    }

    private String xmlTag(String tag, String value) {
        return "\t<" + tag + ">" + value + "</" + tag + ">\n";
    }

    protected void onSnippetModified() {
        String contents = this.document.get();
        MavenDependencyXmlParser parser = new MavenDependencyXmlParser();
        try {
            Optional groupId = parser.getGroupId(contents);
            Optional artifactId = parser.getArtifactId(contents);
            Optional version = parser.getVersion(contents);
            Optional classifier = parser.getClassifier(contents);
            Optional scope = parser.getScope(contents);
            Optional type = parser.getType(contents);
            Optional systemPath = parser.getSystemPath(contents);
            Optional optional = parser.getOptional(contents);
            if (groupId != null) {
                this.mavenDependency.setGroupId(groupId.orElse(""));
            }
            if (artifactId != null) {
                this.mavenDependency.setArtifactId(artifactId.orElse(""));
            }
            if (version != null) {
                this.mavenDependency.setVersion(version.orElse(""));
            }
            if (classifier != null) {
                this.mavenDependency.setClassifier(classifier.orElse(""));
            }
            if (scope != null) {
                String scopeString = scope.orElse("compile");
                MavenDependency.Scope scopeValue = scopeString.isEmpty() ? null : MavenDependency.Scope.value((String)scopeString);
                this.mavenDependency.setScope(scopeValue);
            }
            if (type != null) {
                this.mavenDependency.setType(type.orElse(this.getDefaultType()));
            }
            if (systemPath != null) {
                this.mavenDependency.setSystemPath(systemPath.orElse(""));
            }
            if (optional != null) {
                String optionalString = optional.orElse("false");
                Boolean optionalBoolean = Boolean.parseBoolean(optionalString);
                this.mavenDependency.setOptional(optionalBoolean);
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logWarning((String)("Exception while parsing XML Snippet. Contents:\n" + contents), (Throwable)e);
        }
    }

    private void createInstallLocalComposite(Composite container) {
        Composite blank = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(false, false).hint(-1, 10).applyTo((Control)blank);
        Composite composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(composite);
        this.addLabelWithDecorator(composite);
        this.addInstallButton(composite);
    }

    private void addLabelWithDecorator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(INSTALL_DEPENDENCY_MESSAGE);
        ControlDecoration decorator = new ControlDecoration((Control)label, 0x1020000);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        decorator.setImage(image);
        decorator.setDescriptionText(INSTALL_INFO_TEXT);
        ThemeUtils.setCssId((Object)label, (String)"maven-dependency-install-label");
    }

    private void addInstallButton(Composite composite) {
        Button button = new Button(composite, 0);
        button.setText(INSTALL_BUTTON_LABEL);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallArtifact installJar = new InstallArtifact();
                installJar.execute();
                installJar.getInstalledArtifact().ifPresent(x -> {
                    MavenDependencyPicker.this.groupIdField.setText(x.getGroupId());
                    MavenDependencyPicker.this.artifactIdField.setText(x.getArtifactId());
                    MavenDependencyPicker.this.versionField.setText(x.getVersion());
                    x.getClassifier().ifPresent(classifier -> MavenDependencyPicker.this.classifierField.setText(classifier));
                    x.getType().ifPresent(type -> {
                        if (!"jar".equals(type)) {
                            MavenDependencyPicker.this.typeField.setText(type);
                        }
                    });
                });
            }
        });
    }

    private void createParametersComposite(Composite definitionComposite) {
        Group group = this.createGroupWithLabel(definitionComposite, ARTIFACT_DEFINITION);
        this.definitionFieldsListener = new DefinitionFieldsListener();
        String[] labels = new String[]{GROUP_ID, ARTIFACT_ID, VERSION};
        int maxWidth = this.getMaxWidth((Control)group, labels);
        this.groupIdField = this.initializeTextField((Composite)group, maxWidth, GROUP_ID, this.getDefaultGroupId(), this.definitionFieldsListener);
        this.artifactIdField = this.initializeTextField((Composite)group, maxWidth, ARTIFACT_ID, this.getDefaultArtifact(), this.definitionFieldsListener);
        this.versionField = this.initializeTextField((Composite)group, maxWidth, VERSION, this.getDefaultVersion(), this.definitionFieldsListener);
        this.fieldsMavenDependencyListener = new FieldsMavenDependencyListener();
        this.mavenDependency.addDependencyChangeListener(this.fieldsMavenDependencyListener);
    }

    private int getMaxWidth(Control label, String[] labels) {
        int maxWidth = 0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Point hintForControl = WidgetUtils.getHintForControl((Control)label, (int)string.length());
            maxWidth = hintForControl.x > maxWidth ? hintForControl.x : maxWidth;
            ++n2;
        }
        return maxWidth;
    }

    private ComboViewer initializeScopeField(Composite container, int maxWidth, String labelText, MavenDependency.Scope defaultValue, ISelectionChangedListener modifyListener) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        GridDataFactory.swtDefaults().align(1, 0x1000000).hint(maxWidth != 0 ? maxWidth : -1, -1).applyTo((Control)label);
        ComboViewer combo = new ComboViewer(container);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(combo.getControl());
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MavenDependency.Scope scope = (MavenDependency.Scope)element;
                return scope.asString();
            }
        });
        combo.setInput((Object)MavenDependency.Scope.values());
        combo.setSelection((ISelection)new StructuredSelection((Object)defaultValue));
        combo.addSelectionChangedListener(modifyListener);
        return combo;
    }

    private Text initializeTextField(Composite container, int maxWidth, String labelText, String defaultValue, ModifyListener modifyListener) {
        return this.initializeTextField(container, maxWidth, labelText, defaultValue, true, modifyListener);
    }

    private Text initializeTextField(Composite container, int maxWidth, String labelText, String defaultValue, boolean allowsChange, ModifyListener modifyListener) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        GridDataFactory.swtDefaults().align(1, 0x1000000).hint(maxWidth != 0 ? maxWidth : -1, -1).applyTo((Control)label);
        Text textField = new Text(container, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textField);
        textField.setMessage(defaultValue);
        textField.setEnabled(allowsChange);
        textField.addModifyListener(modifyListener);
        return textField;
    }

    public void setAllowsTypeChange(boolean allows) {
        this.allowsTypeChange = allows;
    }

    public void setAllowsClassifierChange(boolean allows) {
        this.allowsClassifierChange = allows;
    }

    public void setDefaultScope(MavenDependency.Scope defaultScope) {
        this.defaultScope = defaultScope;
    }

    public void setDefaultType(String type) {
        this.defaultType = type;
    }

    public String getDefaultArtifact() {
        return this.defaultArtifact;
    }

    public void setDefaultArtifact(String defaultArtifact) {
        this.defaultArtifact = defaultArtifact;
    }

    public String getDefaultGroupId() {
        return this.defaultGroupId;
    }

    public void setDefaultGroupId(String defaultGroupId) {
        this.defaultGroupId = defaultGroupId;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getDefaultClassifier() {
        return this.defaultClassifier;
    }

    public void setDefaultClassifier(String defaultClassifier) {
        this.defaultClassifier = defaultClassifier;
    }

    private final class DefinitionFieldsListener
    implements ModifyListener,
    SelectionListener,
    ISelectionChangedListener {
        private boolean enabled = true;

        private DefinitionFieldsListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.onEvent(e.widget);
        }

        public void widgetSelected(SelectionEvent e) {
            this.onEvent(e.widget);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void onEvent(Widget widget) {
            if (this.enabled) {
                this.startUserModification();
                if (widget == MavenDependencyPicker.this.groupIdField) {
                    MavenDependencyPicker.this.mavenDependency.setGroupId(MavenDependencyPicker.this.groupIdField.getText());
                } else if (widget == MavenDependencyPicker.this.artifactIdField) {
                    MavenDependencyPicker.this.mavenDependency.setArtifactId(MavenDependencyPicker.this.artifactIdField.getText());
                } else if (widget == MavenDependencyPicker.this.versionField) {
                    MavenDependencyPicker.this.mavenDependency.setVersion(MavenDependencyPicker.this.versionField.getText());
                } else if (widget == MavenDependencyPicker.this.classifierField) {
                    MavenDependencyPicker.this.mavenDependency.setClassifier(MavenDependencyPicker.this.classifierField.getText());
                } else if (widget == MavenDependencyPicker.this.scopeField.getControl()) {
                    IStructuredSelection selection = (IStructuredSelection)MavenDependencyPicker.this.scopeField.getSelection();
                    MavenDependencyPicker.this.mavenDependency.setScope((MavenDependency.Scope)selection.getFirstElement());
                } else if (widget == MavenDependencyPicker.this.typeField) {
                    MavenDependencyPicker.this.mavenDependency.setType(MavenDependencyPicker.this.typeField.getText());
                } else if (widget == MavenDependencyPicker.this.systemPathField) {
                    MavenDependencyPicker.this.mavenDependency.setSystemPath(MavenDependencyPicker.this.systemPathField.getText());
                } else if (widget == MavenDependencyPicker.this.optionalCheckbox) {
                    MavenDependencyPicker.this.mavenDependency.setOptional(MavenDependencyPicker.this.optionalCheckbox.getSelection());
                }
                this.endUserModification();
            }
        }

        private void startUserModification() {
            MavenDependencyPicker.this.fieldsMavenDependencyListener.disable();
            MavenDependencyPicker.this.snippetDocumentListener.disable();
        }

        private void endUserModification() {
            MavenDependencyPicker.this.fieldsMavenDependencyListener.enable();
            MavenDependencyPicker.this.snippetDocumentListener.enable();
        }

        public void disable() {
            this.enabled = false;
        }

        public void enable() {
            this.enabled = true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.onEvent((Widget)((ComboViewer)event.getSource()).getControl());
        }
    }

    private final class FieldsMavenDependencyListener
    implements MavenDependencyChangeListener {
        private boolean enabled = true;

        private FieldsMavenDependencyListener() {
        }

        protected void preChange(MavenDependency dependency, Object previous, Object actual) {
            MavenDependencyPicker.this.definitionFieldsListener.disable();
        }

        protected void postChange(MavenDependency dependency, Object previous, Object actual) {
            MavenDependencyPicker.this.definitionFieldsListener.enable();
        }

        @Override
        public void versionChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.versionField.setText(actual != null ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void scopeChanged(MavenDependency dependency, MavenDependency.Scope previous, MavenDependency.Scope actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.scopeField.setSelection((ISelection)(actual != null ? new StructuredSelection((Object)actual) : new StructuredSelection((Object)MavenDependencyPicker.this.getDefaultScope())));
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void groupIdChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.groupIdField.setText(actual != null ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void classifierChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.classifierField.setText(actual != null ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void artifactIdChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.artifactIdField.setText(actual != null ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void typeChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.typeField.setText(actual != null && actual != MavenDependencyPicker.this.getDefaultType() ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void systemPathChanged(MavenDependency dependency, String previous, String actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.systemPathField.setText(actual != null ? actual : "");
                this.postChange(dependency, previous, actual);
            }
        }

        @Override
        public void optionalChanged(MavenDependency dependency, Boolean previous, Boolean actual) {
            if (this.enabled) {
                this.preChange(dependency, previous, actual);
                MavenDependencyPicker.this.optionalCheckbox.setSelection(actual != null ? actual : false);
                this.postChange(dependency, previous, actual);
            }
        }

        public void disable() {
            this.enabled = false;
        }

        public void enable() {
            this.enabled = true;
        }
    }

    private final class SnippetDocumentListener
    implements IDocumentListener {
        private boolean enabled = true;

        private SnippetDocumentListener() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.enabled) {
                this.startUserModification();
                MavenDependencyPicker.this.onSnippetModified();
                this.endUserModification();
            }
        }

        private void startUserModification() {
            MavenDependencyPicker.this.definitionFieldsListener.disable();
            MavenDependencyPicker.this.snippetMavenDependencyListener.disable();
        }

        private void endUserModification() {
            MavenDependencyPicker.this.snippetMavenDependencyListener.enable();
            MavenDependencyPicker.this.definitionFieldsListener.enable();
        }
    }

    private final class SnippetMavenDependencyListener
    extends MavenDependencyChangeAdapter {
        private boolean enabled = true;

        private SnippetMavenDependencyListener() {
        }

        @Override
        protected void defaultChange(MavenDependency dependency, Object previous, Object actual) {
            if (this.enabled) {
                MavenDependencyPicker.this.updateSnippet();
            }
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }
    }
}

