/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.query.MavenQuery;
import org.mule.tooling.core.m2.query.MavenQueryCallback;
import org.mule.tooling.core.m2.query.MavenQueryResult;
import org.mule.tooling.core.m2.query.MavenQueryResultItem;
import org.mule.tooling.core.m2.query.MavenSearchEngine;
import org.mule.tooling.core.m2.query.QueryType;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.ui.m2.dependency.MavenDependencySearchListener;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.util.SearchResultLabelProvider;

public class MavenArtifactSearchComponent {
    private static final String BACK = "< Back";
    private static final String EDIT_SELECTED = "Edit selected";
    private static final String MORE_RESULTS = "More results";
    private Text searchTextField;
    private List<MavenSearchEngine> searchEngines;
    private MavenSearchEngine currentEngine;
    private Composite thisComposite;
    private TableViewer resultsViewer;
    private String searchTerm = "";
    private MavenQueryCallback mavenQueryCallback;
    private IRunnableContext runnableContext;
    private List<MavenQueryResult> currentResults;
    private Button backButton;
    private Button editButton;
    private MavenDependency selectedDependency;
    private List<MavenDependencySearchListener> mavenSearchListeners;

    public MavenArtifactSearchComponent(IRunnableContext runnableContext, List<MavenSearchEngine> searchEngines, Text searchTextField) {
        this.runnableContext = runnableContext;
        this.searchEngines = searchEngines;
        this.searchTextField = searchTextField;
        this.currentEngine = searchEngines.get(0);
        this.currentResults = new ArrayList<MavenQueryResult>();
        this.mavenSearchListeners = new ArrayList<MavenDependencySearchListener>();
    }

    public Optional<MavenDependency> getSelectedDependency() {
        return Optional.ofNullable(this.selectedDependency);
    }

    public void setCurrentEngine(MavenSearchEngine currentEngine) {
        this.currentEngine = currentEngine;
    }

    private void searchTermModified(String searchTerm) {
        this.searchTerm = searchTerm;
        final List<MavenQuery> queries = this.getQueries(searchTerm);
        this.currentResults.clear();
        if (!searchTerm.isEmpty()) {
            this.runInRunnableContext(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MavenArtifactSearchComponent.this.executeQueries(queries, monitor);
                }
            });
        }
    }

    private void executeQueries(List<MavenQuery> queries, IProgressMonitor monitor) {
        String name = "Executing quer" + (queries.size() > 1 ? "ies" : "y");
        monitor.beginTask(name, queries.size());
        try {
            for (MavenQuery mavenQuery : queries) {
                if (monitor.isCanceled()) continue;
                mavenQuery.execute(this.getQueryCallback(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void runInRunnableContext(IRunnableWithProgress runnable) {
        try {
            this.runnableContext.run(false, true, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            MuleCorePlugin.logError((String)"There was a problem executing the search query", (Throwable)e);
        }
    }

    private List<MavenQuery> getQueries(String searchTerm) {
        List queryTypes = this.currentEngine.getQueryTypes();
        ArrayList<MavenQuery> queries = new ArrayList<MavenQuery>();
        for (QueryType queryType : queryTypes) {
            MavenQuery query = queryType.newBuilder().setSearchTerm(searchTerm).build();
            queries.add(query);
        }
        return queries;
    }

    private MavenQueryCallback getQueryCallback() {
        if (this.mavenQueryCallback == null) {
            this.mavenQueryCallback = new MavenQueryCallback(){

                public void finished(MavenQueryResult result) {
                    MavenArtifactSearchComponent.this.onQueryFinished(result);
                }
            };
        }
        return this.mavenQueryCallback;
    }

    public Composite createControl(Composite parent) {
        this.thisComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(5, 5, 0, 5).spacing(LayoutConstants.getSpacing().x, (int)((double)LayoutConstants.getSpacing().y * 1.5)).applyTo(this.thisComposite);
        this.createLabelsHeader();
        this.createResultsViewer();
        this.createButtonsBar();
        this.searchTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (MavenDependencySearchListener mavenDependencySearchListener : MavenArtifactSearchComponent.this.mavenSearchListeners) {
                    mavenDependencySearchListener.onQueryChanged(MavenArtifactSearchComponent.this.searchTextField.getText());
                }
            }
        });
        this.searchTextField.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenArtifactSearchComponent.this.searchTermModified(MavenArtifactSearchComponent.this.searchTextField.getText());
            }
        }, (Control)this.searchTextField));
        return this.thisComposite;
    }

    public void addEditButtonListener(SelectionListener listener) {
        this.editButton.addSelectionListener(listener);
    }

    public void addBackButtonListener(SelectionListener listener) {
        this.backButton.addSelectionListener(listener);
    }

    private void createButtonsBar() {
        Group composite = new Group(this.thisComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)composite);
        this.createBackButton((Composite)composite);
        Composite composite2 = new Composite((Composite)composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)composite2);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite2);
        this.createMoreResultsButton(composite2);
        this.createEditSelectedButton(composite2);
    }

    private void createEditSelectedButton(Composite parent) {
        this.editButton = new Button(parent, 0);
        this.editButton.setText(EDIT_SELECTED);
        this.editButton.setEnabled(false);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.editButton);
    }

    private void createMoreResultsButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(MORE_RESULTS);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenArtifactSearchComponent.this.onMoreResultsSelected();
            }
        });
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)button);
    }

    private void onMoreResultsSelected() {
        for (final MavenQueryResult result : new ArrayList<MavenQueryResult>(this.currentResults)) {
            this.runInRunnableContext(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.getNextResults(MavenArtifactSearchComponent.this.getQueryCallback(), monitor);
                }
            });
        }
    }

    private void createBackButton(Composite composite) {
        this.backButton = new Button(composite, 0);
        this.backButton.setText(BACK);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.backButton);
    }

    private void createResultsViewer() {
        this.resultsViewer = new TableViewer(this.thisComposite, 68352);
        this.resultsViewer.getTable().setLinesVisible(true);
        this.resultsViewer.setContentProvider((IContentProvider)new MavenQueryResultsProvider());
        TableViewerColumn column = new TableViewerColumn(this.resultsViewer, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.resultsViewer.getTable().setLayout((Layout)layout);
        SearchResultLabelProvider labelProvider = new SearchResultLabelProvider(() -> this.searchTerm, this.resultsViewer.getTable().getFont()){

            protected String getText(Object element) {
                MavenQueryResultItem result = (MavenQueryResultItem)element;
                String gavString = MavenUtils.getGavString((MavenDependency)result.getDependency());
                return gavString;
            }
        };
        labelProvider.setOwnerDrawEnabled(true);
        column.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        this.resultsViewer.addSelectionChangedListener(this.getResultsSelectionChangedListener());
        this.resultsViewer.setInput(this.currentResults);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.resultsViewer.getTable());
    }

    private ISelectionChangedListener getResultsSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                MavenArtifactSearchComponent.this.onResultSelectionChanged(selection);
            }
        };
    }

    private void onResultSelectionChanged(ISelection selection) {
        boolean emptySelection = selection.isEmpty();
        this.editButton.setEnabled(!emptySelection);
        if (!emptySelection) {
            MavenQueryResultItem resultItem = (MavenQueryResultItem)((IStructuredSelection)selection).getFirstElement();
            this.selectedDependency = resultItem.getDependency();
        } else {
            this.selectedDependency = null;
        }
    }

    private void createLabelsHeader() {
        Link label = new Link(this.thisComposite, 0);
        label.setText("Searching " + this.searchEngines.get(0).getName() + (this.searchEngines.size() > 1 ? " (<a>change</a>)" : ""));
        label.setFont(this.getBoldFont((Control)label));
        GridDataFactory.fillDefaults().applyTo((Control)label);
    }

    private void onQueryFinished(MavenQueryResult result) {
        if (result.isSuccesful()) {
            this.currentResults.add(result);
            this.resultsViewer.refresh();
            TableItem[] items = this.resultsViewer.getTable().getItems();
            if (items.length > 0) {
                this.resultsViewer.getTable().showItem(items[items.length - 1]);
            }
        } else {
            for (MavenDependencySearchListener mavenSearchListener : this.mavenSearchListeners) {
                mavenSearchListener.onQueryFailed(result);
            }
        }
    }

    private Font getBoldFont(Control imageLabel) {
        return JFaceResources.getFontRegistry().getBold(this.thisComposite.getFont().getFontData()[0].getName());
    }

    public void addSearchListener(MavenDependencySearchListener listener) {
        this.mavenSearchListeners.add(listener);
    }

    private class MavenQueryResultsProvider
    implements IStructuredContentProvider {
        private MavenQueryResultsProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List results = (List)inputElement;
            ArrayList dependencies = new ArrayList();
            for (MavenQueryResult result : results) {
                if (!result.isSuccesful()) continue;
                dependencies.addAll(result.getResults());
            }
            return dependencies.toArray(new Object[dependencies.size()]);
        }
    }
}

