/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.util.Optional;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dependencymanagement.BaseRequirementManager;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.ui.command.InstallArtifact;

public class LocalFileRequirementManager
extends BaseRequirementManager {
    private static final String ADD_ACTION_ID = "USE_LOCAL_FILE";
    private static final String ADD_ACTION_LABEL = "Use local file";

    public LocalFileRequirementManager() {
        super(ADD_ACTION_ID, ADD_ACTION_LABEL, "", "");
    }

    public boolean applies(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement) {
        return RequirementDependencyManager.Action.ADD.equals((Object)action);
    }

    public Optional<MavenDependency> run(RequirementDependencyManager.Action action, Shell activeShell, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        InstallArtifact installArtifact = new InstallArtifact("Choose local file", "Use a local file for the required library. It is not necessary to provide specific Maven configuration, usually default values will suffice.", Optional.empty(), true);
        installArtifact.execute();
        Optional<MavenDependency> installedArtifact = installArtifact.getInstalledArtifact();
        installedArtifact.ifPresent(dep -> muleProject.getMuleProjectModel().addMavenDependency(dep));
        return installedArtifact;
    }
}

