/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.osgi.services.ServicesRegistry;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspectorService;
import org.mule.tooling.ui.m2.dependency.DefaultFileCoordinatesExtension;
import org.mule.tooling.ui.m2.dependency.DefaultFileCoordinatesProvider;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.errors.ErrorDetailDialog;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class InstallArtifactDialog
extends TitleAreaDialog {
    private static final int TEXT_FIELD_H_INDENT = 15;
    private static final String XML_EXTENSION = "xml";
    private static final String FILE_DOES_NOT_EXISTS_ERROR_MESSAGE = "File does not exists";
    private static final String MISSING_FIELD_ERROR_MESSAGE = "Cannot be empty";
    private static final String SELECT_FILE_DIALOG_TEXT = "Select File";
    private static final String SELECT_POM_DIALOG_TITLE = "Select Pom";
    private static final String BROWSE_CAPTION = "Browse...";
    private static final String ANY_FILE_FILTER_CAPTION = "Any";
    private static final String JAR_FILE_FILTER_CAPTION = "jar";
    private static final String DLL_FILE_FILTER_CAPTION = "dll";
    private static final String SO_FILE_FILTER_CAPTION = "so";
    private static final String DYLIB_FILE_FILTER_CAPTION = "dylib";
    private static final String JNILIB_FILE_FILTER_CAPTION = "jnilib";
    private static final String JAR_FILE_CAPTION = "File";
    private static final String POM_FILE_FILTER_CAPTION = "XML";
    private static final String POM_FILE_FILTER_ALT_CAPTION = "POM";
    private static final String POM_FILE_CAPTION = "POM File";
    private static final String VERSION_CAPTION = "Version";
    private static final String ANY_FILE_EXTENSION = "*.*";
    private static final String JAR_FILE_EXTENSION = "*.jar";
    private static final String DLL_FILE_EXTENSION = "*.dll";
    private static final String SO_FILE_EXTENSION = "*.so";
    private static final String DYLIB_FILE_FILTER_EXTENSION = "*.dylib";
    private static final String JNILIB_FILE_FILTER_EXTENSION = "*.jnilib";
    private static final String POM_FILE_EXTENSION = "*.xml";
    private static final String POM_FILE_ALT_EXTENSION = "*.pom";
    private static final String POM_FILE_NAME = "pom";
    private static final String ARTIFACT_ID_CAPTION = "Artifact ID";
    private static final String GROUP_ID_CAPTION = "Group ID";
    private static final String CLASSIFIER_CAPTION = "Classifier";
    private static final String GROUP_TITLE = "Advanced settings";
    private Text artifactText;
    private Text pomText;
    private Text groupIdText;
    private Text artifactIdText;
    private Text versionText;
    private Text classifierText;
    private String artifactPath;
    private String pomPath;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private MavenJarFileInspectorService mavenJarInspectorService;
    private final String title;
    private final String description;
    private final boolean sharedLibrary;
    private Optional<String> okButtonText;

    public InstallArtifactDialog(Shell parentShell, String title, String description, Optional<String> okButtonText, boolean sharedLibrary) {
        super(parentShell);
        this.title = title;
        this.description = description;
        this.okButtonText = okButtonText;
        this.sharedLibrary = sharedLibrary;
        this.mavenJarInspectorService = ServicesRegistry.get().getMavenJarInspectorService();
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(this.description);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        int verticalSpacing = 3;
        int margins = 10;
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(margins, margins, margins, margins).spacing(LayoutConstants.getSpacing().x, verticalSpacing).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        this.createJarOrAnyFilePicker(container);
        int columns = 3;
        int textSpan = columns - 1;
        Group jarGroupBox = UiUtils.createGroupWithTitle(container, GROUP_TITLE, columns);
        GridDataFactory.createFrom((GridData)((GridData)jarGroupBox.getLayoutData())).span(3, 1).applyTo((Control)jarGroupBox);
        this.createPomFilePicker((Composite)jarGroupBox);
        Optional<Validator> requiredFieldValidator = Optional.of(this.getRequiredValidator());
        Optional<String> groupIdDefaultValue = Optional.of("com.mycompany");
        Optional<String> artifactIdMessage = Optional.of("custom-artifact");
        Optional<String> versionDefaultValue = Optional.of("0.1");
        this.groupIdText = this.createTextInput((Composite)jarGroupBox, GROUP_ID_CAPTION, groupIdDefaultValue, Optional.empty(), textSpan);
        this.artifactIdText = this.createTextInput((Composite)jarGroupBox, ARTIFACT_ID_CAPTION, artifactIdMessage, requiredFieldValidator, textSpan);
        this.versionText = this.createTextInput((Composite)jarGroupBox, VERSION_CAPTION, versionDefaultValue, Optional.empty(), textSpan);
        this.classifierText = this.createTextInput((Composite)jarGroupBox, CLASSIFIER_CAPTION, Optional.empty(), Optional.empty(), textSpan);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstallArtifactDialog.this.groupId = InstallArtifactDialog.this.getTextOrMessage(InstallArtifactDialog.this.groupIdText);
                InstallArtifactDialog.this.artifactId = InstallArtifactDialog.this.artifactIdText.getText();
                InstallArtifactDialog.this.version = InstallArtifactDialog.this.getTextOrMessage(InstallArtifactDialog.this.versionText);
                InstallArtifactDialog.this.artifactPath = InstallArtifactDialog.this.artifactText.getText();
                InstallArtifactDialog.this.pomPath = InstallArtifactDialog.this.pomText.getText();
                InstallArtifactDialog.this.classifier = InstallArtifactDialog.this.classifierText.getText();
                InstallArtifactDialog.this.updateOkButtonEnablement();
            }
        };
        this.groupIdText.addModifyListener(listener);
        this.artifactIdText.addModifyListener(listener);
        this.versionText.addModifyListener(listener);
        this.artifactText.addModifyListener(listener);
        this.classifierText.addModifyListener(listener);
        return area;
    }

    private String getTextOrMessage(Text text) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text.getText()) ? text.getMessage() : text.getText();
    }

    private void enableTextInput() {
        this.updateTextInputEnablement(true);
    }

    private void disableTextInput() {
        this.updateTextInputEnablement(false);
    }

    private void updateTextInputEnablement(boolean enabled) {
        this.groupIdText.setEnabled(enabled);
        this.artifactIdText.setEnabled(enabled);
        this.versionText.setEnabled(enabled);
        this.classifierText.setEnabled(enabled);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialize();
        ThemeUtils.setCssId((Object)control, (String)"installArtifactDialog");
        return control;
    }

    private void initialize() {
        this.artifactText.setText("");
        this.pomText.setText("");
        this.clearGAVC();
        this.updateOkButtonEnablement();
    }

    private void clearGAVC() {
        this.groupIdText.setText("");
        this.artifactIdText.setText("");
        this.versionText.setText("");
        this.classifierText.setText("");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButtonText.ifPresent(buttonText -> this.getButton(0).setText(buttonText));
    }

    private void createPomFilePicker(Composite jarGroupBox) {
        this.pomText = this.createTextInput(jarGroupBox, POM_FILE_CAPTION, Optional.of(this.getPomValidator()));
        this.createBrowser(jarGroupBox, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile = InstallArtifactDialog.this.selectFileFromDialog(InstallArtifactDialog.SELECT_POM_DIALOG_TITLE, new String[]{InstallArtifactDialog.POM_FILE_EXTENSION, InstallArtifactDialog.POM_FILE_ALT_EXTENSION}, new String[]{InstallArtifactDialog.POM_FILE_FILTER_CAPTION, InstallArtifactDialog.POM_FILE_FILTER_ALT_CAPTION}, Optional.of(InstallArtifactDialog.POM_FILE_NAME));
                if (selectedFile != null) {
                    InstallArtifactDialog.this.populateFromPom(selectedFile);
                    InstallArtifactDialog.this.pomText.setText(selectedFile);
                }
            }
        });
        this.pomText.addModifyListener((ModifyListener)new FileSelectorListener());
    }

    private void createJarOrAnyFilePicker(Composite parent) {
        this.artifactText = this.createTextInput(parent, JAR_FILE_CAPTION, Optional.of("Select a file from your system"), Optional.of(this.getJarValidator()), 1);
        this.createBrowser(parent, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile = InstallArtifactDialog.this.selectFileFromDialog(InstallArtifactDialog.SELECT_FILE_DIALOG_TEXT, new String[]{InstallArtifactDialog.JAR_FILE_EXTENSION, InstallArtifactDialog.DLL_FILE_EXTENSION, InstallArtifactDialog.SO_FILE_EXTENSION, InstallArtifactDialog.DYLIB_FILE_FILTER_EXTENSION, InstallArtifactDialog.JNILIB_FILE_FILTER_EXTENSION, InstallArtifactDialog.ANY_FILE_EXTENSION}, new String[]{InstallArtifactDialog.JAR_FILE_FILTER_CAPTION, InstallArtifactDialog.DLL_FILE_FILTER_CAPTION, InstallArtifactDialog.SO_FILE_FILTER_CAPTION, InstallArtifactDialog.DYLIB_FILE_FILTER_CAPTION, InstallArtifactDialog.JNILIB_FILE_FILTER_CAPTION, InstallArtifactDialog.ANY_FILE_FILTER_CAPTION}, Optional.empty());
                if (selectedFile != null) {
                    InstallArtifactDialog.this.artifactText.setText(selectedFile);
                }
            }
        });
        this.artifactText.addModifyListener((ModifyListener)new FileSelectorListener());
    }

    private String selectFileFromDialog(String title, String[] filterExtensions, String[] filterNames, Optional<String> fileName) {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
        fileDialog.setText(title);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterNames(filterNames);
        if (fileName.isPresent()) {
            fileDialog.setFileName(fileName.get());
        }
        return fileDialog.open();
    }

    private void updateEnablementAndCoordinatesIfArtifactExists(String filePath) {
        if (StringUtils.isNotBlank((String)filePath) && this.fileExists(filePath)) {
            this.populateFromArtifactIfRequired(filePath);
        }
    }

    private void populateFromArtifactIfRequired(String filePath) {
        if (this.pomIsNotConfigured() && this.fileExists(filePath)) {
            if (this.hasJarFileExtension(filePath)) {
                this.loadInformationFromJar(filePath);
            } else {
                this.loadDefaultsFrom(filePath);
            }
            String fileName = FilenameUtils.getName((String)filePath);
            Optional<DefaultFileCoordinatesProvider> defaultCoordinates = DefaultFileCoordinatesExtension.getDefaultsFor(fileName);
            defaultCoordinates.ifPresent(def -> {
                def.getDefaultGroupId().ifPresent(t -> this.groupIdText.setText(t));
                def.getDefaultArtifactId().ifPresent(t -> this.artifactIdText.setText(t));
                def.getDefaultVersion().ifPresent(t -> this.versionText.setText(t));
                def.getDefaultClassifier().ifPresent(t -> this.classifierText.setText(t));
            });
        }
    }

    private void loadInformationFromJar(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jarFile = new JarFile(file);){
                    MavenJarFileInspector inspector = this.mavenJarInspectorService.getInspector(jarFile);
                    if (inspector.hasPomFile()) {
                        this.artifactIdText.setText(inspector.getArtifactId());
                        this.groupIdText.setText(inspector.getGroupId());
                        this.versionText.setText(inspector.getVersion());
                        this.classifierText.setText(MavenUtils.getClassifier((String)fileName, (String)inspector.getArtifactId(), (String)inspector.getVersion(), (String)FilenameUtils.getExtension((String)filePath)));
                        this.disableTextInput();
                    } else if (!this.isValidPomFile()) {
                        this.clearGAVC();
                        this.loadDefaultsFrom(filePath);
                        this.enableTextInput();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ErrorDetailDialog.openError((Shell)this.getShell(), (String)("Unexpected error reading file " + fileName), (String)ex.getMessage(), (String)ExceptionUtils.getStackTrace((Throwable)ex));
                this.enableTextInput();
                this.updateOkButtonEnablement();
            }
        }
        finally {
            this.updateOkButtonEnablement();
        }
    }

    private void loadDefaultsFrom(String filePath) {
        this.artifactIdText.setText(FilenameUtils.getBaseName((String)filePath));
    }

    private boolean hasJarFileExtension(String filePath) {
        return JAR_FILE_FILTER_CAPTION.equals(FilenameUtils.getExtension((String)filePath));
    }

    private boolean isArtifactFileConfigured() {
        return StringUtils.isNotBlank((String)this.artifactText.getText());
    }

    private boolean pomIsNotConfigured() {
        return StringUtils.isBlank((String)this.pomText.getText());
    }

    private boolean isValidPomFile() {
        File file;
        String pomPath = this.pomText.getText();
        if (pomPath != null && XML_EXTENSION.equals(FilenameUtils.getExtension((String)pomPath)) && (file = new File(pomPath)).exists()) {
            MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (FileReader pomReader = new FileReader(file);){
                    Model pomModel = mavenXpp3Reader.read((Reader)pomReader);
                    boolean bl = pomModel != null;
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | XmlPullParserException throwable) {
                return false;
            }
        }
        return false;
    }

    private void populateFromPom(String filePath) {
        File file;
        if (XML_EXTENSION.equals(FilenameUtils.getExtension((String)filePath)) && (file = new File(filePath)).exists() && file.isFile()) {
            try {
                try {
                    MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
                    Model pomModel = mavenXpp3Reader.read((Reader)new FileReader(file));
                    this.artifactIdText.setText(pomModel.getArtifactId());
                    this.groupIdText.setText(pomModel.getGroupId());
                    this.versionText.setText(pomModel.getVersion());
                    this.disableTextInput();
                }
                catch (Exception ex) {
                    ErrorDetailDialog.openError((Shell)this.getShell(), (String)("Unexpected error reading file " + file.getName()), (String)ex.getMessage(), (String)ExceptionUtils.getStackTrace((Throwable)ex));
                    this.enableTextInput();
                    this.updateOkButtonEnablement();
                }
            }
            finally {
                this.updateOkButtonEnablement();
            }
        }
    }

    private void updateOkButtonEnablement() {
        boolean hasAnyError = this.hasErrors();
        this.getButton(0).setEnabled(!hasAnyError);
    }

    private boolean hasErrors() {
        return StringUtils.isBlank((String)this.getTextOrMessage(this.groupIdText)) || StringUtils.isBlank((String)this.artifactIdText.getText()) || StringUtils.isBlank((String)this.getTextOrMessage(this.versionText)) || StringUtils.isBlank((String)this.artifactText.getText()) || !this.fileExists(this.artifactText.getText()) || StringUtils.isNotBlank((String)this.pomText.getText()) && !this.fileExists(this.pomText.getText());
    }

    private boolean fileExists(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        File file = path.toFile();
        return file.exists() && file.isFile();
    }

    private Text createTextInput(Composite container, String label, Optional<Validator> validator) {
        return this.createTextInput(container, label, Optional.empty(), validator, 1);
    }

    private Text createTextInput(Composite container, String label, Optional<String> defaultValue, Optional<Validator> validateComponent, int inputSpan) {
        this.createLabel(container, label);
        final Text textField = new Text(container, 2048);
        defaultValue.ifPresent(arg_0 -> ((Text)textField).setMessage(arg_0));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(inputSpan, 1).indent(15, 0).applyTo((Control)textField);
        if (validateComponent.isPresent()) {
            final Validator validator = validateComponent.get();
            textField.addModifyListener(new ModifyListener(){
                ControlDecoration decorator;
                {
                    this.decorator = new ControlDecoration((Control)text, 0x1000000);
                    Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
                    this.decorator.setImage(image);
                }

                public void modifyText(ModifyEvent e) {
                    if (!validator.validateFunction.apply(textField.getText()).booleanValue()) {
                        this.decorator.setDescriptionText(validator.messageSupplier.apply(textField.getText()));
                        this.decorator.show();
                        InstallArtifactDialog.this.updateOkButtonEnablement();
                    } else {
                        this.decorator.hide();
                        InstallArtifactDialog.this.updateOkButtonEnablement();
                    }
                }
            });
        }
        return textField;
    }

    private void createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
    }

    private void createBrowser(Composite container, SelectionAdapter selectionListener) {
        Button button = new Button(container, 8);
        button.setText(BROWSE_CAPTION);
        GridDataFactory.swtDefaults().align(131072, 0x1000000).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)selectionListener);
    }

    public File getArtifactFile() {
        return new File(this.artifactPath);
    }

    public Optional<File> getPomFile() {
        File pomFile = null;
        if (this.pomPath != null && StringUtils.isNotBlank((String)this.pomPath) && !(pomFile = new File(this.pomPath.trim())).exists()) {
            return Optional.empty();
        }
        return Optional.ofNullable(pomFile);
    }

    public MavenDependency getArtifact() {
        PojoMavenDependencyBuilder artifactBuilder = (PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withArtifactId(this.artifactId)).withGroupId(this.groupId)).withVersion(this.version)).withType(FilenameUtils.getExtension((String)this.artifactPath));
        if (StringUtils.isNotBlank((String)this.classifier)) {
            artifactBuilder.withClassifier(this.classifier);
        }
        artifactBuilder.beingShared(this.sharedLibrary);
        return artifactBuilder.build();
    }

    private Validator getRequiredValidator() {
        Validator validator = new Validator();
        validator.validateFunction = org.apache.commons.lang3.StringUtils::isNotBlank;
        validator.messageSupplier = x -> MISSING_FIELD_ERROR_MESSAGE;
        return validator;
    }

    private Validator getJarValidator() {
        Validator validator = new Validator();
        validator.validateFunction = fileName -> StringUtils.isNotBlank((String)fileName) && this.fileExists((String)fileName);
        validator.messageSupplier = fileName -> StringUtils.isBlank((String)fileName) ? MISSING_FIELD_ERROR_MESSAGE : FILE_DOES_NOT_EXISTS_ERROR_MESSAGE;
        return validator;
    }

    private Validator getPomValidator() {
        Validator validator = new Validator();
        validator.validateFunction = fileName -> StringUtils.isBlank((String)fileName) || StringUtils.isNotBlank((String)fileName) && this.fileExists((String)fileName);
        validator.messageSupplier = content -> FILE_DOES_NOT_EXISTS_ERROR_MESSAGE;
        return validator;
    }

    private class FileSelectorListener
    implements ModifyListener {
        private FileSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (InstallArtifactDialog.this.pomIsNotConfigured()) {
                if (InstallArtifactDialog.this.isArtifactFileConfigured()) {
                    InstallArtifactDialog.this.updateEnablementAndCoordinatesIfArtifactExists(InstallArtifactDialog.this.artifactText.getText());
                } else {
                    InstallArtifactDialog.this.clearGAVC();
                    InstallArtifactDialog.this.enableTextInput();
                }
            } else {
                InstallArtifactDialog.this.populateFromPom(InstallArtifactDialog.this.pomText.getText());
            }
        }
    }

    private static final class Validator {
        private Function<String, Boolean> validateFunction;
        private Function<String, String> messageSupplier;

        private Validator() {
        }
    }
}

