/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.ui.m2.dependency.DefaultFileCoordinatesExtension;

public final class DefaultFileCoordinatesProvider {
    private static final String CONTAINS_GROUP_REFERENCES_REGEX = ".*\\$[0-9].*";
    private final DefaultFileCoordinatesExtension extension;
    private final String fileName;

    public DefaultFileCoordinatesProvider(DefaultFileCoordinatesExtension defaultFileCoordinatesExtension, String fileName) {
        this.extension = defaultFileCoordinatesExtension;
        this.fileName = fileName;
    }

    public Optional<String> getDefaultGroupId() {
        return this.getReplacingValuesIfNecessary(this.fileName, this.extension.getGroupIdExpression());
    }

    public Optional<String> getDefaultArtifactId() {
        return this.getReplacingValuesIfNecessary(this.fileName, this.extension.getArtifactIdExpression());
    }

    public Optional<String> getDefaultVersion() {
        return this.getReplacingValuesIfNecessary(this.fileName, this.extension.getVersionExpression());
    }

    public Optional<String> getDefaultClassifier() {
        return this.getReplacingValuesIfNecessary(this.fileName, this.extension.getClassifierExpression());
    }

    private Optional<String> getReplacingValuesIfNecessary(String fileName, String expressionValue) {
        Optional<String> result = Optional.empty();
        if (StringUtils.isNotBlank((CharSequence)expressionValue)) {
            result = this.containsReferences(expressionValue) ? Optional.of(this.performRegexReplacements(fileName, expressionValue)) : Optional.of(expressionValue);
        }
        return result;
    }

    private boolean containsReferences(String value) {
        return value.matches(CONTAINS_GROUP_REFERENCES_REGEX);
    }

    private String performRegexReplacements(String fileName, String valueToReplace) {
        String result = valueToReplace;
        Matcher matcher = Pattern.compile(this.extension.getFileNameRegex()).matcher(fileName);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            int i = 0;
            while (i <= groupCount) {
                String groupValue = this.getGroupValue(matcher, i);
                String groupReplacementExpression = "$" + i;
                if (result.contains(groupReplacementExpression)) {
                    result = result.replaceAll("\\" + groupReplacementExpression, groupValue);
                }
                ++i;
            }
        }
        return result;
    }

    private String getGroupValue(Matcher matcher, int groupNumber) {
        String groupValue = matcher.group(groupNumber);
        return StringUtils.isNotBlank((CharSequence)groupValue) ? groupValue : "";
    }
}

