/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.m2.dependency;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.ui.m2.dependency.DefaultFileCoordinatesProvider;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

@ExtensionPoint(extensionPointId="org.mule.tooling.ui.m2.dependency.defaultcoordinates")
public class DefaultFileCoordinatesExtension {
    @ExtensionAttribute
    private String fileNameRegex;
    @ExtensionAttribute(optional=true)
    private String groupIdExpression = "";
    @ExtensionAttribute(optional=true)
    private String artifactIdExpression = "";
    @ExtensionAttribute(optional=true)
    private String versionExpression = "";
    @ExtensionAttribute(optional=true)
    private String classifierExpression = "";

    public static List<DefaultFileCoordinatesExtension> getExtensions() {
        return Singleton.extensions;
    }

    public static Optional<DefaultFileCoordinatesProvider> getDefaultsFor(String fileName) {
        return DefaultFileCoordinatesExtension.getExtensions().stream().filter(ext -> ext.matches(fileName)).map(ext -> ext.createDefaultsProvider(fileName)).findFirst();
    }

    public boolean matches(String fileName) {
        return fileName.matches(this.fileNameRegex);
    }

    public DefaultFileCoordinatesProvider createDefaultsProvider(String fileName) {
        return new DefaultFileCoordinatesProvider(this, fileName);
    }

    public void setFileNameRegex(String fileNameRegex) {
        this.fileNameRegex = fileNameRegex;
    }

    public void setGroupIdExpression(String groupId) {
        this.groupIdExpression = groupId;
    }

    public void setArtifactIdExpression(String artifactIdExpression) {
        this.artifactIdExpression = artifactIdExpression;
    }

    public void setVersionExpression(String versionExpression) {
        this.versionExpression = versionExpression;
    }

    public void setClassifierExpression(String classifierExpression) {
        this.classifierExpression = classifierExpression;
    }

    public String getFileNameRegex() {
        return this.fileNameRegex;
    }

    public String getGroupIdExpression() {
        return this.groupIdExpression;
    }

    public String getArtifactIdExpression() {
        return this.artifactIdExpression;
    }

    public String getVersionExpression() {
        return this.versionExpression;
    }

    public String getClassifierExpression() {
        return this.classifierExpression;
    }

    private static class Singleton {
        private static final List<DefaultFileCoordinatesExtension> extensions = IExtensionPointReader.create(DefaultFileCoordinatesExtension.class).readAll();

        private Singleton() {
        }
    }
}

