/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.launchConfiguration.extensible;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;

public abstract class ExtensibleLaunchConfigTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    private static final String CHILDREN_TARGET_LAUNCH_CONFIG_TAB = "targetLaunchConfigTab";
    private static final String ATTRIBUTE_TARGET_LAUNCH_CONFIG_ID = "id";
    private static final int DEFAULT_START_LEVEL = 10;
    private static final String ATTRIBUTE_LEVEL = "level";
    public static final String EXTENSION_POINT_ID_LAUNCH_CONFIG_PARTS = "org.mule.tooling.ui.launchconfigpart";
    private List<LaunchConfigPartExtension> extensions;
    private String name;

    public ExtensibleLaunchConfigTab(String extensibleLaunchConfigTabId, String name) throws CoreException {
        this.name = name;
        this.extensions = new ArrayList<LaunchConfigPartExtension>();
        this.loadLaunchConfigPartExtensions(extensibleLaunchConfigTabId);
    }

    private void loadLaunchConfigPartExtensions(String extensibleLaunchConfigTabId) throws CoreException {
        List<LaunchConfigPartExtensionHolder> extensionPointObjects = this.getLaunchConfigPartExtensionHolders();
        Collections.sort(extensionPointObjects);
        for (LaunchConfigPartExtensionHolder holder : extensionPointObjects) {
            if (!extensibleLaunchConfigTabId.equals(holder.getTargetLaunchConfigTabId())) continue;
            this.getExtensions().add(holder.getExtensionObject());
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        for (LaunchConfigPartExtension extension : this.getExtensions()) {
            Control extensionContainer = extension.createControl(container);
            extension.setPropertyChangeListener(this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(extensionContainer);
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(container);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)container);
        this.setControl((Control)container);
    }

    protected List<LaunchConfigPartExtensionHolder> getLaunchConfigPartExtensionHolders() throws CoreException {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID_LAUNCH_CONFIG_PARTS);
        ArrayList<LaunchConfigPartExtensionHolder> extensionObjects = new ArrayList<LaunchConfigPartExtensionHolder>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                this.doLoadExtensionObject(extensionObjects, configurationElement);
            }
            catch (Throwable e) {
                MuleUIPlugin.getDefault().logError("There was an error initializing a LaunchConfigPartExtension", e);
            }
            ++n2;
        }
        return extensionObjects;
    }

    void doLoadExtensionObject(List<LaunchConfigPartExtensionHolder> extensionObjects, IConfigurationElement configurationElement) throws CoreException {
        IConfigurationElement[] children;
        LaunchConfigPartExtension extensionObject = (LaunchConfigPartExtension)LaunchConfigPartExtension.class.cast(configurationElement.createExecutableExtension("class"));
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren(CHILDREN_TARGET_LAUNCH_CONFIG_TAB);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            LaunchConfigPartExtensionHolder extensionHolder = new LaunchConfigPartExtensionHolder(extensionObject, this.getTargetLaunchConfigTabId(child), this.getExtensionLevel(child));
            extensionObjects.add(extensionHolder);
            ++n2;
        }
    }

    private String getTargetLaunchConfigTabId(IConfigurationElement element) {
        return element.getAttribute(ATTRIBUTE_TARGET_LAUNCH_CONFIG_ID);
    }

    private int getExtensionLevel(IConfigurationElement configurationElement) throws CoreException {
        try {
            String attribute = configurationElement.getAttribute(ATTRIBUTE_LEVEL);
            if (attribute != null) {
                Integer integerValue = Integer.valueOf(attribute);
                return integerValue;
            }
            return 10;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.ui", "Trying to load a LaunchConfigPartExtension that provided a non-numeric level"));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (LaunchConfigPartExtension extension : this.getExtensions()) {
            extension.initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (LaunchConfigPartExtension extension : this.getExtensions()) {
            extension.performApply(configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (LaunchConfigPartExtension extension : this.getExtensions()) {
            extension.setDefaults(configuration);
        }
    }

    public String getName() {
        return this.name;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }

    public List<LaunchConfigPartExtension> getExtensions() {
        return this.extensions;
    }

    public void dispose() {
        for (LaunchConfigPartExtension extension : this.getExtensions()) {
            extension.dispose();
        }
    }

    protected class LaunchConfigPartExtensionHolder
    implements Comparable<LaunchConfigPartExtensionHolder> {
        private final LaunchConfigPartExtension extensionObject;
        private final int extensionLevel;
        private final String targetLaunchConfigTabId;

        public LaunchConfigPartExtensionHolder(LaunchConfigPartExtension extensionObject, String targetLaunchConfigTabId, int extensionLevel) {
            this.extensionObject = extensionObject;
            this.targetLaunchConfigTabId = targetLaunchConfigTabId;
            this.extensionLevel = extensionLevel;
        }

        public LaunchConfigPartExtension getExtensionObject() {
            return this.extensionObject;
        }

        public int getExtensionLevel() {
            return this.extensionLevel;
        }

        public String getTargetLaunchConfigTabId() {
            return this.targetLaunchConfigTabId;
        }

        @Override
        public int compareTo(LaunchConfigPartExtensionHolder other) {
            return this.getExtensionLevel() - other.getExtensionLevel();
        }
    }
}

