/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.launchConfiguration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;
import org.mule.tooling.ui.utils.UiUtils;

public class StartAsClusterComponent
implements LaunchConfigPartExtension {
    private static final String UNDEFINED = StartAsClusterComponent.class.getCanonicalName() + ".undefined-node-id";
    public static final String FROM_UUID = StartAsClusterComponent.class.getCanonicalName() + ".generate-uuid";
    public static final String CLUSTER_NODE_ID = "clusterNodeId";
    private Button startAsClusterCheckBox;
    private Text nodeIdText;
    private String nodeId;
    private boolean selection = false;
    private IPropertyChangeListener propertyChangeListener;
    private SelectionAdapter checkboxSelectionListener;
    private ModifyListener textModifyListener;

    @Override
    public Control createControl(Composite parent) {
        Group composite = UiUtils.createGroupWithTitle(parent, "Clustering", 2);
        this.startAsClusterCheckBox = new Button((Composite)composite, 32);
        this.startAsClusterCheckBox.setText("Start as cluster node");
        GridDataFactory.swtDefaults().applyTo((Control)this.startAsClusterCheckBox);
        this.nodeIdText = new Text((Composite)composite, 2048);
        this.nodeIdText.setMessage("Node ID or empty for random ID");
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.nodeIdText);
        return composite;
    }

    private void clearPreviousState() {
        this.nodeId = null;
        this.selection = false;
    }

    protected void onNodeIdModified(String text) {
        String oldNodeId = this.nodeId;
        this.nodeId = text;
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, CLUSTER_NODE_ID, (Object)oldNodeId, (Object)text));
    }

    protected void onCheckboxSelected(boolean selection) {
        this.selection = selection;
        this.nodeIdText.setEnabled(selection);
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "clusterNodeIdselected", (Object)(!selection ? 1 : 0), (Object)selection));
    }

    @Override
    public void runPreLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    @Override
    public void runPostLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.clearPreviousState();
        String clusterNodeId = UNDEFINED;
        try {
            clusterNodeId = configuration.getAttribute(CLUSTER_NODE_ID, UNDEFINED);
        }
        catch (CoreException e) {
            MuleUIPlugin.getDefault().logError("There was a problem retrieving the clustering configuration from the existing run configuration", e);
        }
        boolean isUndefined = UNDEFINED.equals(clusterNodeId);
        boolean isUuid = FROM_UUID.equals(clusterNodeId);
        this.selection = !isUndefined;
        this.startAsClusterCheckBox.setSelection(this.selection);
        this.nodeIdText.setEnabled(this.selection);
        this.nodeId = isUndefined || isUuid ? "" : clusterNodeId;
        this.nodeIdText.setText(this.nodeId);
        this.nodeIdText.addModifyListener(this.getTextModifyListener());
        this.startAsClusterCheckBox.addSelectionListener((SelectionListener)this.getCheckboxSelectionListener());
    }

    private SelectionAdapter getCheckboxSelectionListener() {
        if (this.checkboxSelectionListener == null) {
            this.checkboxSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StartAsClusterComponent.this.onCheckboxSelected(StartAsClusterComponent.this.startAsClusterCheckBox.getSelection());
                }
            };
        }
        return this.checkboxSelectionListener;
    }

    private ModifyListener getTextModifyListener() {
        if (this.textModifyListener == null) {
            this.textModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StartAsClusterComponent.this.onNodeIdModified(StartAsClusterComponent.this.nodeIdText.getText());
                }
            };
        }
        return this.textModifyListener;
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selection) {
            this.nodeId = this.nodeId == null || this.nodeId.isEmpty() ? FROM_UUID : this.nodeId;
            configuration.setAttribute(CLUSTER_NODE_ID, this.nodeId);
        } else {
            configuration.removeAttribute(CLUSTER_NODE_ID);
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute(CLUSTER_NODE_ID);
    }

    @Override
    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    @Override
    public void dispose() {
    }
}

