/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.jface;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IExternalDomain;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.MuleImages;

public class MuleLabelProvider
extends LabelProvider {
    public static String getProjectSuffix(IProject project) {
        return new MuleLabelProvider().doGetProjectSuffix(project);
    }

    public Image getImage(Object element) {
        if (element instanceof IMuleDomain) {
            return MuleImages.MULE_DOMAIN_IMAGE;
        }
        if (element instanceof IMuleProject) {
            IMuleProject muleProject = (IMuleProject)element;
            if (MuleProjectKind.APPLICATION.classifies(muleProject)) {
                return MuleImages.MULE_APP_IMAGE;
            }
            return MuleImages.IMG_MULE_SMALL;
        }
        if (element instanceof IServerDefinition) {
            return MuleImages.IMG_MULE_SMALL;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IMuleDomain) {
            IMuleDomain muleDomain = (IMuleDomain)element;
            return muleDomain.getDomainName() + this.getDomainSuffix(muleDomain);
        }
        if (element instanceof IMuleProject) {
            IProject project = ((IMuleProject)element).getProject();
            return project.getName() + this.doGetProjectSuffix(project);
        }
        if (element instanceof IServerDefinition) {
            return ((IServerDefinition)element).getLabel();
        }
        return super.getText(element);
    }

    protected String getDomainSuffix(IMuleDomain muleDomain) {
        String suffix = "";
        if (muleDomain instanceof IExternalDomain) {
            suffix = " (external domain)";
        } else if (muleDomain instanceof IMuleDomainProject) {
            IMuleDomainProject muleDomainProject = (IMuleDomainProject)muleDomain;
            suffix = this.doGetProjectSuffix(muleDomainProject.getProject());
        }
        return suffix;
    }

    protected String doGetProjectSuffix(IProject project) {
        String result = "";
        IMuleProject muleProject = MuleLabelProvider.getMuleProject(project);
        if (muleProject != null) {
            switch (muleProject.getProjectModelState()) {
                case MISSING: {
                    result = " < pom.xml is missing";
                    break;
                }
                case INVALID: {
                    result = " < pom.xml has problems";
                    break;
                }
                case VALID: {
                    result = this.getProjectTypeSpecificText(project);
                }
            }
        }
        return result;
    }

    protected String getProjectTypeSpecificText(IProject project) {
        try {
            IMuleDomainProject domainProject;
            if (MuleProjectKind.APPLICATION.classifies(project)) {
                IMuleApplicationProject applicationProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(project);
                if (!applicationProject.hasDefaultDomain()) {
                    Optional<IMuleDomain> maybeDomain = Optional.ofNullable(applicationProject.getDomain());
                    return maybeDomain.map(domain -> {
                        StringBuilder domainLabelDecoration = new StringBuilder();
                        if (domain.isExternal()) {
                            domainLabelDecoration.append(" (external domain: " + DomainMavenDependencyComparator.toGavString((MavenDependency)domain.getMavenCoordinates()));
                        } else {
                            domainLabelDecoration.append(" (project domain: " + domain.getDomainName());
                        }
                        domainLabelDecoration.append(")");
                        return domainLabelDecoration.toString();
                    }).orElse("");
                }
            } else if (MuleProjectKind.DOMAIN.classifies(project) && !(domainProject = (IMuleDomainProject)MuleProjectKind.DOMAIN.adapt(project)).getDomainName().equals(project.getName())) {
                return " : " + domainProject.getDomainName();
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem trying to get the domain of a project for label decoration", (Throwable)e);
        }
        return "";
    }

    private static IMuleProject getMuleProject(IProject project) {
        IMuleProject muleProject = null;
        if (project.isAccessible()) {
            muleProject = MuleRuntime.create((IProject)project);
        }
        return muleProject;
    }
}

