/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.editors;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class FeaturedModulesDialog
extends Dialog {
    private List<ExternalContributionMuleModule> input;
    private Shell shell;
    private Composite dialog;
    private Group group;
    private Label title;
    private Runnable onFinish;
    private Composite tableComposite;
    private CheckboxTableViewer table;

    public FeaturedModulesDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setInput(List<ExternalContributionMuleModule> input) {
        this.input = input;
    }

    public List<ExternalContributionMuleModule> getSelectedModules() {
        return Arrays.stream(this.table.getCheckedElements()).map(ExternalContributionMuleModule.class::cast).collect(Collectors.toList());
    }

    public void open(Runnable onFinish) {
        this.onFinish = onFinish;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0x10000000);
        this.shell.setLayout((Layout)FormLayoutUtils.formLayout((int)10, (int)10));
        this.dialog = new Composite((Composite)this.shell, 0);
        this.dialog.setLayout((Layout)FormLayoutUtils.formLayout());
        this.group = new Group(this.dialog, 0);
        this.group.setLayout((Layout)FormLayoutUtils.formLayout());
        FormLayoutUtils.attach((Control)this.dialog).top().left().right().bottom();
        FormLayoutUtils.attach((Control)this.group).top().left().right();
        this.createTitle();
        this.createTable();
        this.createButtons();
        this.shell.pack();
        this.shell.open();
    }

    private void createTitle() {
        this.title = new Label((Composite)this.group, 0);
        this.title.setText("Please select modules to add: ");
        FormLayoutUtils.attach((Control)this.title).top().left();
    }

    private void createTable() {
        this.tableComposite = new Composite((Composite)this.group, 0);
        this.tableComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)10, (int)10));
        this.table = CheckboxTableViewer.newCheckList((Composite)this.tableComposite, (int)512);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ExternalContributionMuleModule dependency = (ExternalContributionMuleModule)element;
                return dependency.getName();
            }
        });
        this.table.setInput(this.input);
        FormLayoutUtils.attach((Control)this.tableComposite).topFrom((Control)this.title, 10).left().right();
        FormLayoutUtils.attach((Control)this.table.getTable()).top().left().right().bottom();
    }

    private void createButtons() {
        Button cancel = new Button(this.dialog, 8);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeaturedModulesDialog.this.close();
            }
        });
        Button ok = new Button(this.dialog, 8);
        ok.setText("OK");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeaturedModulesDialog.this.onFinish.run();
                FeaturedModulesDialog.this.shell.close();
            }
        });
        FormLayoutUtils.attach((Control)ok).topFrom((Control)this.group, 10).right(5).bottom(5);
        FormLayoutUtils.attach((Control)cancel).rightFrom((Control)ok, 5).alignBottom((Control)ok);
    }

    protected void close() {
        this.shell.close();
    }
}

