/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.editors;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.exchange.ExchangeAssetAttributesInfo;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyActionListener;
import org.mule.tooling.ui.properties.IDependencySelectedListener;
import org.mule.tooling.ui.properties.IExchangeAsset;
import org.mule.tooling.ui.properties.SnapshotState;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.utils.OnPremUtils;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class DependencyInfo
extends Composite
implements IDependencySelectedListener,
IDependencyActionListener {
    private static final String UPDATE_NOW = "Update version";
    private static final String NEW_VERSION_AVAILABLE = "New version available";
    private static final String VIEW_IN = "View in ";
    private static final String LINK_ELEMENT_CLOSE = "</a>";
    private static final String LINK_ELEMENT_END = "\">";
    private static final String LINK_ELEMENT_START = "<a href=\"";
    private static final String EDIT_IN = "Edit in ";
    private static final String MULESOFT_VCS = "MuleSoft VCS";
    private static final String EXCHANGE = "Exchange";
    private static final String PROGRESS_LABEL_INITIAL_TEXT = "Fetching alternative versions";
    private static final String PLEASE_SELECT_DEPENDENCY = "Please select or add a dependency to see more information.";
    private Group dependencyInformation;
    private Composite progressComposite;
    private ProgressBar progressBar;
    private Label progressLabel;
    private Optional<Control> updateButton;
    private DependencyController<?> dependencyController;

    public DependencyInfo(DependencyController<?> dependencyController, Composite dialog, int style) {
        super(dialog, style);
        this.dependencyController = dependencyController;
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        this.createContent();
    }

    private void createContent() {
        this.dependencyInformation = new Group((Composite)this, 0);
        this.dependencyInformation.setLayout((Layout)FormLayoutUtils.formLayout((int)10, (int)10));
        FormLayoutUtils.attach((Control)this.dependencyInformation).top().left().right().bottom();
        this.fillInformation(Optional.empty());
    }

    public boolean shouldCreateProgressBar() {
        return true;
    }

    private void fillInformation(Optional<IDependency> dependency) {
        Control top = this.createTitle(dependency);
        top = this.createUpdate(dependency, top).orElse(top);
        top = dependency.isPresent() ? this.createSeparator(top) : top;
        top = this.createDescription(dependency, top).orElse(top);
        top = this.createExchangeLink(dependency, top).orElse(top);
        top = this.createDesignCenterLink(dependency, top).orElse(top);
        FormData layoutData = (FormData)top.getLayoutData();
        layoutData.bottom = new FormAttachment(100);
        this.relayout();
    }

    private void relayout() {
        Composite parent = this.getParent();
        while (parent != null && !(parent instanceof ScrolledComposite)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledComposite) {
            int minWidth = ((ScrolledComposite)parent).getMinWidth();
            Control content = ((ScrolledComposite)parent).getContent();
            if (content != null) {
                ((ScrolledComposite)parent).setMinSize(minWidth, content.computeSize((int)-1, (int)-1).y);
            }
        }
        this.dependencyInformation.layout();
        this.layout();
    }

    private Control createSeparator(Control top) {
        Label separator = new Label((Composite)this.dependencyInformation, 258);
        FormLayoutUtils.attach((Control)separator).topFrom(top, 5).left().right();
        return separator;
    }

    private Optional<Control> createDesignCenterLink(Optional<IDependency> dependency, Control top) {
        ExchangeAssetAttributesInfo presentExchangeAssetAttributesInfo;
        Optional projectId;
        Optional<ExchangeAssetAttributesInfo> exchangeAssetAttributesInfo;
        IDependency dep;
        if (dependency.isPresent() && !OnPremUtils.isHyperforceEnabled() && (dep = dependency.get()) instanceof IExchangeAsset && (exchangeAssetAttributesInfo = ((IExchangeAsset)((Object)dep)).getExchangeAssetAttributesInfo()).isPresent() && (projectId = (presentExchangeAssetAttributesInfo = exchangeAssetAttributesInfo.get()).getDesignCenterProjectId()).isPresent()) {
            String designCenterProjectId = (String)projectId.get();
            String dcLink = PlatformUrls.getApiDesignerProjectUrl((String)designCenterProjectId);
            Link designCenter = new Link((Composite)this.dependencyInformation, 0);
            designCenter.setText(this.getLink(EDIT_IN, dcLink, MULESOFT_VCS));
            designCenter.addListener(13, onClick -> {
                AnalyticsRecordsFactory.single((String)Events.EDIT_IN_DESIGN_CENTER_LINK).withDependencyProperty(Arrays.asList(dep.getDependency())).withDesignCenterProjectID(designCenterProjectId).addMetadata("SpecificationType", this.isRamlDependency(dep) ? "RAML" : "OAS").track();
                Program.launch((String)dcLink);
            });
            FormLayoutUtils.attach((Control)designCenter).topFrom(top, 0).left().right();
            return Optional.of(designCenter);
        }
        return Optional.empty();
    }

    private Optional<Control> createExchangeLink(Optional<IDependency> dependency, Control top) {
        IDependency dep;
        if (dependency.isPresent() && (dep = dependency.get()) instanceof IExchangeAsset) {
            String link = ((IExchangeAsset)((Object)dep)).getLink();
            Link exchange = new Link((Composite)this.dependencyInformation, 0);
            exchange.setText(this.getLink(VIEW_IN, link, EXCHANGE));
            exchange.addListener(13, onClick -> {
                AnalyticsRecordsFactory.single((String)Events.VIEW_IN_EXCHANGE_LINK).withDependencyProperty(Arrays.asList(dep.getDependency())).addMetadata("SpecificationType", this.isRamlDependency(dep) ? "RAML" : "OAS").track();
                Program.launch((String)link);
            });
            FormLayoutUtils.attach((Control)exchange).topFrom(top, 5).left().right();
            return Optional.of(exchange);
        }
        return Optional.empty();
    }

    private boolean isRamlDependency(IDependency dep) {
        String classifier = dep.getClassifier();
        return classifier.equals("raml") || classifier.equals("raml-fragment");
    }

    private String getLink(String prefix, String link, String name) {
        return prefix + LINK_ELEMENT_START + link + LINK_ELEMENT_END + name + LINK_ELEMENT_CLOSE;
    }

    private Optional<Control> createUpdate(Optional<IDependency> dependency, Control top) {
        Composite updates = null;
        if (dependency.isPresent()) {
            boolean isSnapshot;
            IDependency dep = dependency.get();
            String latestVersion = DependencyUtils.getLatestVersion(dep);
            boolean newVersionAvailable = !latestVersion.equals(dep.getVersion());
            boolean bl = isSnapshot = dep.isSnapshot() && this.dependencyController.supportSnapshots();
            if (newVersionAvailable || isSnapshot) {
                updates = new Composite((Composite)this.dependencyInformation, 0);
                updates.setLayout((Layout)FormLayoutUtils.formLayout((int)0, (int)5));
                FormLayoutUtils.attach((Control)updates).topFrom(top, 5).left().right();
                Optional<Control> newVersionInfo = this.createNewVersionInfo(dependency, top, updates, dep, latestVersion, newVersionAvailable);
                this.createSnapshotInfo(updates, dependency.get(), isSnapshot, newVersionInfo);
            }
        }
        return Optional.ofNullable(updates);
    }

    private void createSnapshotInfo(Composite updates, IDependency snapshot, boolean isSnapshot, Optional<Control> newVersionInfo) {
        if (isSnapshot) {
            Composite snapshotComposite = new Composite(updates, 0);
            snapshotComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)0, (int)5));
            FormLayoutUtils.FormDataHelper attach = FormLayoutUtils.attach((Control)snapshotComposite).left().right();
            if (newVersionInfo.isPresent()) {
                attach.topFrom(newVersionInfo.get(), 5);
            } else {
                attach.top();
            }
            SnapshotState snapshotState = this.dependencyController.getState(snapshot);
            Label snapshotLabel = new Label(snapshotComposite, 0);
            this.setGrayColor(snapshotLabel);
            FormLayoutUtils.attach((Control)snapshotLabel).top().left();
            Button checkSnapshotButton = new Button(snapshotComposite, 8);
            this.updateTexts(snapshotState, snapshotLabel, checkSnapshotButton);
            checkSnapshotButton.addListener(13, e -> this.dependencyController.snapshotChangeState(snapshot));
            FormLayoutUtils.attach((Control)checkSnapshotButton).alignMiddle((Control)snapshotLabel).right();
        }
    }

    private void updateTexts(SnapshotState snapshotState, Label snapshotLabel, Button checkSnapshotButton) {
        snapshotLabel.setText(snapshotState.getUserMessage());
        checkSnapshotButton.setText(snapshotState.getButtonMessage());
        checkSnapshotButton.setEnabled(snapshotState.isButtonEnabled());
    }

    private Optional<Control> createNewVersionInfo(Optional<IDependency> dependency, Control top, Composite updates, IDependency dep, String latestVersion, boolean newVersionAvailable) {
        Optional<Control> result = Optional.empty();
        if (newVersionAvailable) {
            Composite versions = new Composite(updates, 0);
            versions.setLayout((Layout)FormLayoutUtils.formLayout((int)0, (int)5));
            FormLayoutUtils.attach((Control)versions).top().left().right();
            Label updateAvailable = new Label(versions, 0);
            updateAvailable.setText(NEW_VERSION_AVAILABLE);
            this.setGrayColor(updateAvailable);
            FormLayoutUtils.attach((Control)updateAvailable).top().left();
            Button updateButton = new Button(versions, 8);
            updateButton.setText(UPDATE_NOW);
            updateButton.addListener(13, e -> {
                AnalyticsRecordsFactory.single((String)Events.UPDATED_API_FROM_API_PROPERTY_PAGE).withDependencyProperty(Arrays.asList(dep.getDependency())).track();
                this.updateDependency(dependency, latestVersion);
            });
            FormLayoutUtils.attach((Control)updateButton).alignMiddle((Control)updateAvailable).right();
            this.updateButton = Optional.of(updateButton);
            result = Optional.ofNullable(versions);
        }
        return result;
    }

    private void setGrayColor(Label label) {
        label.setForeground(this.getDisplay().getSystemColor(16));
    }

    public void updateDependency(Optional<IDependency> dependency, String latestVersion) {
        dependency.get().setVersion(latestVersion);
        this.dependencyController.versionChanged(dependency.get(), latestVersion);
    }

    private Optional<Control> createDescription(Optional<IDependency> dependency, Control top) {
        if (dependency.isPresent()) {
            Label desc = new Label((Composite)this.dependencyInformation, 64);
            IDependency dep = dependency.get();
            if (StringUtils.isNotBlank((CharSequence)dep.getDescription())) {
                desc.setText(dep.getDescription());
            } else {
                desc.setText("There is no description for this dependency");
            }
            FormLayoutUtils.attach((Control)desc).topFrom(top, 10).left().right();
            return Optional.of(desc);
        }
        return Optional.empty();
    }

    private Control createVersion(Optional<IDependency> dependency, Control top) {
        Label version = new Label((Composite)this.dependencyInformation, 16448);
        if (dependency.isPresent()) {
            boolean isSnapshot;
            version.setText(dependency.get().getVersion());
            FormLayoutUtils.FormDataHelper versionData = FormLayoutUtils.attach((Control)version).alignTop(top).alignBottom(top).leftFrom(top, 5);
            boolean bl = isSnapshot = dependency.get().isSnapshot() && this.dependencyController.supportSnapshots();
            if (isSnapshot) {
                Label info = new Label((Composite)this.dependencyInformation, 0);
                info.setImage(MuleImages.IMG_INFO);
                info.setToolTipText("Snapshot versions are not meant for production use because a change in the dependency may impact behaviour after deployment.");
                FormLayoutUtils.attach((Control)info).alignMiddle((Control)version).leftFrom((Control)version, 5);
            } else {
                versionData.right();
            }
        } else {
            FormData layoutData = (FormData)top.getLayoutData();
            layoutData.right = new FormAttachment(100);
        }
        return version;
    }

    private Control createTitle(Optional<IDependency> dependency) {
        Label title = new Label((Composite)this.dependencyInformation, 64);
        if (dependency.isPresent()) {
            FontData fontData = title.getFont().getFontData()[0];
            Font font = new Font((Device)this.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
            title.setFont(font);
            title.setText(dependency.get().getName());
            title.setToolTipText(dependency.get().getName());
        } else {
            title.setText(PLEASE_SELECT_DEPENDENCY);
            title.setToolTipText(PLEASE_SELECT_DEPENDENCY);
        }
        FormLayoutUtils.attach((Control)title).top().left();
        this.createVersion(dependency, (Control)title);
        return title;
    }

    @Override
    public void dependencySelected(Optional<IDependency> asset) {
        if (this.dependencyInformation.isDisposed()) {
            return;
        }
        Stream.of(this.dependencyInformation.getChildren()).filter(control -> !control.isDisposed()).forEach(Widget::dispose);
        this.fillInformation(asset);
    }

    public ProgressComposite getProgress() {
        this.createProgress();
        return new ProgressComposite(this.progressLabel, this.progressBar);
    }

    public void createProgress() {
        FormLayoutUtils.attach((Control)this.dependencyInformation).top().left().right();
        this.progressComposite = new Composite((Composite)this, 0);
        FormLayoutUtils.attach((Control)this.progressComposite).topFrom((Control)this.dependencyInformation, 0).left().right().bottom();
        this.progressComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)5, (int)5));
        this.progressBar = new ProgressBar(this.progressComposite, 65536);
        this.progressLabel = new Label(this.progressComposite, 0);
        this.progressLabel.setText(PROGRESS_LABEL_INITIAL_TEXT);
        FormLayoutUtils.attach((Control)this.progressLabel).top().left().right();
        FormLayoutUtils.attach((Control)this.progressBar).topFrom((Control)this.progressLabel, 0).left().right().bottom();
        this.layout();
    }

    @Override
    public void dependencyAdded(IDependency dependency) {
        this.dependenciesAdded(Arrays.asList(dependency));
    }

    @Override
    public void dependencyRemoved(IDependency dependency) {
    }

    @Override
    public void dependencyUpdated(IDependency dependency) {
        this.dependencySelected(Optional.ofNullable(dependency));
    }

    @Override
    public void dependenciesAdded(List<IDependency> dependencies) {
        if (this.isDisposed()) {
            return;
        }
        ProgressComposite progress = this.getProgress();
        this.layout();
        this.dependencyController.fetchVersions(dependencies, progress);
    }

    @Override
    public void dependenciesUpdated() {
        if (!this.isDisposed()) {
            this.layout();
        }
    }

    public Optional<Control> getUpdateButton() {
        return this.updateButton;
    }

    @Override
    public void snapshotStateChanged(IDependency dependency, SnapshotState state) {
        this.dependencySelected(Optional.of(dependency));
    }

    @Override
    public void dependenciesRemoved() {
    }

    public class ProgressComposite {
        private final Label label;
        private final ProgressBar progressBar;

        public ProgressComposite(Label label, ProgressBar progressBar) {
            this.label = label;
            this.progressBar = progressBar;
        }

        public ProgressBar getProgressBar() {
            return this.progressBar;
        }

        public Label getLabel() {
            return this.label;
        }

        public void dispose() {
            if (!DependencyInfo.this.progressComposite.isDisposed()) {
                DependencyInfo.this.progressComposite.dispose();
            }
            if (!DependencyInfo.this.isDisposed()) {
                FormLayoutUtils.attach((Control)DependencyInfo.this.dependencyInformation).top().left().right().bottom();
            }
        }
    }
}

