/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.editors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.m2.dependency.MuleVersionComparator;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.EditDependencyDialog;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyActionListener;
import org.mule.tooling.ui.properties.IFetchDependenciesVersionsListener;
import org.mule.tooling.ui.properties.SnapshotState;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class DependenciesTable
extends Composite
implements IDependencyActionListener {
    private static final String DEPENDENCIES_TABLE_CSS_CLASS_ID = "org-mule-tooling-ui-DependenciesTable";
    private static final String EDIT_SELECTED_DEPENDENCY_VERSION = "Edit selected dependency version";
    private static final String REMOVE_SELECTED_DEPENDENCY = "Remove selected dependency";
    private static final String ADD_NEW_DEPENDENCY = "Add new dependency";
    private static final String CHECK_FOR_UPDATES = "Check for updates";
    private static final String UPDATE_ALL_DEPENDENCIES_TO_LATEST = "Update all dependencies to latest";
    private List<IDependency> input;
    private List<IDependency> modifiedInput;
    private DependencyController<?> dependencyController;
    private List<IFetchDependenciesVersionsListener> fetchDependenciesListeners = new ArrayList<IFetchDependenciesVersionsListener>();
    private List<DependencyColumn> columns = Lists.newArrayList();
    private List<AddItem> addItems = Lists.newArrayList();
    private ToolItem removeItem;
    private ToolItem editItem;
    private TableViewer table;
    private ToolItem updateAllItem;
    private ToolItem checkForUpdates;

    public DependenciesTable(DependencyController<?> dependencyController, Composite dialog, int style) {
        super(dialog, style);
        this.dependencyController = dependencyController;
        this.setLayout((Layout)FormLayoutUtils.formLayout());
    }

    public void addColumn(String name, int width, Function<IDependency, String> display, ModifyAction update, Function<IDependency, Set<String>> values) {
        this.columns.add(new DependencyColumn(name, width, display, update, values));
    }

    public void addColumn(String name, int width, Function<IDependency, String> display, ModifyAction update, Function<IDependency, Set<String>> values, CellLabelProvider labelProvider) {
        this.columns.add(new DependencyColumn(name, width, display, update, values, labelProvider));
    }

    public void contributeAddItem(String name, Runnable action, int index) {
        this.addItems.add(index, new AddItem(name, action));
    }

    public void addFetchDependenciesListener(IFetchDependenciesVersionsListener listener) {
        this.fetchDependenciesListeners.add(listener);
    }

    public void contributeAddItem(String name, Runnable action) {
        this.addItems.add(new AddItem(name, action));
    }

    public void createContent() {
        Control lToolbar = this.createLeftToolbar();
        FormLayoutUtils.attach((Control)lToolbar).top().left().right(50, 0);
        Control rToolbar = this.createRightToolbar();
        FormLayoutUtils.attach((Control)rToolbar).top().right();
        Control table = this.createTable(false);
        FormLayoutUtils.attach((Control)table).topFrom(lToolbar, 0).left().right().bottom();
        this.refreshButtons(Optional.empty());
        ThemeUtils.setCssClassAndId((Object)this, (String)DEPENDENCIES_TABLE_CSS_CLASS_ID, (String)DEPENDENCIES_TABLE_CSS_CLASS_ID);
    }

    private Control createLeftToolbar() {
        Composite toolbarComposite = FormLayoutUtils.composite((Composite)this);
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x800000);
        this.createLeftButtons(toolBar);
        toolBar.pack();
        return toolbarComposite;
    }

    private Control createRightToolbar() {
        Composite toolbarComposite = FormLayoutUtils.composite((Composite)this);
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x800000);
        this.createRightButtons(toolBar);
        toolBar.pack();
        return toolbarComposite;
    }

    private void createRightButtons(ToolBar toolBar) {
        this.checkForUpdates = this.createButton(toolBar, MuleImages.DESC_DEPENDENCIES_UPDATE.createImage(), MuleImages.DESC_DEPENDENCIES_UPDATE_DISABLED.createImage(), () -> this.fetchDependenciesListeners.stream().forEach(IFetchDependenciesVersionsListener::fetchAllDependenciesVersions), CHECK_FOR_UPDATES);
        this.updateAllItem = this.createButton(toolBar, ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme ? MuleImages.DESC_UPDATE_DARK.createImage() : MuleImages.DESC_UPDATE.createImage(), ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme ? MuleImages.DESC_UPDATE_DARK_DISABLED.createImage() : MuleImages.DESC_UPDATE_DISABLED.createImage(), () -> this.dependencyController.updateAll(this.getModifiedInput()), UPDATE_ALL_DEPENDENCIES_TO_LATEST);
    }

    private void createLeftButtons(ToolBar toolBar) {
        ToolItem addItem = this.createButton(toolBar, MuleImages.DESC_ADD.createImage(), MuleImages.DESC_ADD_DISABLED.createImage(), () -> {}, ADD_NEW_DEPENDENCY);
        DropdownSelectionListener toolbarListener = new DropdownSelectionListener(addItem);
        this.addItems.forEach(item -> toolbarListener.add(item.getDisplayName(), item.getAction()));
        addItem.addSelectionListener((SelectionListener)toolbarListener);
        this.removeItem = this.createButton(toolBar, MuleImages.DESC_DELETE.createImage(), MuleImages.DESC_DELETE_DISABLED.createImage(), () -> {
            IStructuredSelection structuredSelection = this.table.getStructuredSelection();
            IDependency dependency = (IDependency)structuredSelection.getFirstElement();
            this.dependencyController.dependencyRemoved(dependency);
        }, REMOVE_SELECTED_DEPENDENCY);
        this.editItem = this.createButton(toolBar, MuleImages.DESC_EDIT.createImage(), MuleImages.DESC_EDIT_DISABLED.createImage(), () -> {
            IStructuredSelection structuredSelection = this.table.getStructuredSelection();
            IDependency dependency = (IDependency)structuredSelection.getFirstElement();
            this.openEditDialog(dependency);
        }, EDIT_SELECTED_DEPENDENCY_VERSION);
    }

    private ToolItem createButton(ToolBar toolBar, Image image, Image disabledImage, final Runnable action, String tooltip) {
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setDisabledImage(disabledImage);
        item.setToolTipText(tooltip);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        item.addDisposeListener(d -> {
            image.dispose();
            disabledImage.dispose();
        });
        return item;
    }

    private void openEditDialog(IDependency dependency) {
        EditDependencyDialog editDialog = new EditDependencyDialog(this, dependency);
        String oldVersion = dependency.getVersion();
        editDialog.open(() -> {
            if (!dependency.getVersion().equals(oldVersion)) {
                this.dependencyController.versionChanged(dependency, dependency.getVersion());
            }
        });
    }

    public void refresh() {
        if (!this.table.getTable().isDisposed()) {
            this.table.refresh(true);
        }
    }

    private void refreshButtons(Optional<IDependency> dependencySelection) {
        if (!this.removeItem.isDisposed()) {
            this.removeItem.setEnabled(dependencySelection.isPresent());
        }
        if (!this.editItem.isDisposed()) {
            this.editItem.setEnabled(dependencySelection.isPresent() && this.isEditable(dependencySelection.get()));
        }
        if (!this.updateAllItem.isDisposed()) {
            this.updateAllItem.setEnabled(this.isUpdateAllAvailable());
        }
        this.refreshCheckForUpdatesButton();
    }

    public void disableCheckForUpdatesButton() {
        if (!this.checkForUpdates.isDisposed()) {
            this.checkForUpdates.setEnabled(false);
        }
    }

    public void refreshCheckForUpdatesButton() {
        if (!this.checkForUpdates.isDisposed()) {
            this.checkForUpdates.setEnabled(!this.getModifiedInput().isEmpty());
        }
    }

    private boolean isUpdateAllAvailable() {
        return this.getModifiedInput().stream().anyMatch(dep -> {
            String version = dep.getVersion();
            if (dep.getAvailableVersions().isEmpty()) {
                return false;
            }
            String latestVersion = dep.getAvailableVersions().stream().map(MuleVersion::new).max(MuleVersionComparator.INSTANCE).get().toString();
            return !version.equals(latestVersion);
        });
    }

    private boolean isEditable(IDependency dependency) {
        return dependency.getAvailableVersions().size() > 1;
    }

    public Control createTable(boolean add) {
        Composite tableComposite = new Composite((Composite)this, 0);
        this.table = new TableViewer(tableComposite, 2564);
        this.createColumns(this.table, tableComposite, add);
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.updateTableInput(this.input);
        this.table.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            this.dependencySelected(selection);
        });
        FormLayoutUtils.attach((Control)this.table.getTable()).top().left().right().bottom();
        return tableComposite;
    }

    private void dependencySelected(IStructuredSelection selection) {
        Optional<IDependency> dependencySelection = Optional.empty();
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IDependency) {
                dependencySelection = Optional.ofNullable((IDependency)firstElement);
                this.dependencyController.dependencySelected(dependencySelection);
            }
        } else {
            this.dependencyController.dependencySelected(dependencySelection);
        }
        this.refreshButtons(dependencySelection);
    }

    private void sortDependencies(List<IDependency> list) {
        list.sort((dependency1, dependency2) -> dependency1.getName().compareTo(dependency2.getName()));
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String header) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(header);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        return column;
    }

    private void createColumns(TableViewer viewer, Composite tableComposite, boolean add) {
        TableColumnLayout tableLayout = new TableColumnLayout(true);
        this.columns.forEach(dependencyColumn -> {
            TableViewerColumn column = this.createColumn(viewer, dependencyColumn.getName(), dependencyColumn.getDisplay(), dependencyColumn.getLabelProvider());
            tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, dependencyColumn.getWidth()));
        });
        tableComposite.setLayout((Layout)tableLayout);
    }

    private TableViewerColumn createColumn(TableViewer viewer, String name, final Function<IDependency, String> textFunction, Optional<CellLabelProvider> labelProvider) {
        TableViewerColumn column = this.createTableViewerColumn(viewer, name);
        if (labelProvider.isPresent()) {
            column.setLabelProvider(labelProvider.get());
        } else {
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IDependency) {
                        return (String)textFunction.apply((IDependency)element);
                    }
                    return super.getText(element);
                }
            });
        }
        return column;
    }

    @Override
    public void dependenciesAdded(List<IDependency> dependencies) {
        this.modifiedInput.addAll(dependencies);
        this.updateTableInput(this.modifiedInput);
    }

    @Override
    public void dependencyAdded(IDependency dependency) {
        this.modifiedInput.add(dependency);
        this.updateTableInput(this.modifiedInput);
        this.table.setSelection((ISelection)new StructuredSelection((Object)dependency));
    }

    @Override
    public void dependencyRemoved(IDependency dependency) {
        int previusRemoveIndex = this.table.getTable().getSelectionIndex();
        this.modifiedInput.remove(dependency);
        this.updateTableInput(this.modifiedInput);
        if (!this.getModifiedInput().isEmpty()) {
            previusRemoveIndex = Math.min(previusRemoveIndex, this.getModifiedInput().size() - 1);
            this.table.getTable().setSelection(previusRemoveIndex);
            this.refreshButtons(Optional.ofNullable(this.getModifiedInput().get(previusRemoveIndex)));
        }
    }

    @Override
    public void dependenciesRemoved() {
        this.modifiedInput = Lists.newArrayList();
        this.updateTableInput(this.modifiedInput);
    }

    @Override
    public void dependenciesUpdated() {
        this.refresh();
        this.dependencySelected(this.table.getStructuredSelection());
    }

    @Override
    public void dependencyUpdated(IDependency dependency) {
        this.updateTableInput(this.modifiedInput);
        this.refresh();
        this.dependencySelected(this.table.getStructuredSelection());
    }

    @Override
    public void snapshotStateChanged(IDependency dependency, SnapshotState state) {
        this.refresh();
    }

    public void restoreDefaults() {
        this.updateTableInput(this.input);
        this.setModifiedInput(this.input);
        this.dependencySelected(this.table.getStructuredSelection());
    }

    private void updateTableInput(List<IDependency> list) {
        this.sortDependencies(list);
        this.table.setInput(list);
    }

    public void apply() {
        this.input = Lists.newArrayList(this.modifiedInput);
    }

    public List<IDependency> getInput() {
        return this.input;
    }

    public List<DependencyColumn> getColumns() {
        return this.columns;
    }

    public void setInput(List<IDependency> input) {
        this.input = input;
        this.setModifiedInput(input);
    }

    private void setModifiedInput(List<IDependency> input) {
        this.modifiedInput = Lists.newArrayList(input);
    }

    public List<IDependency> getModifiedInput() {
        return this.modifiedInput;
    }

    public TableViewer getDependenciesTableViewer() {
        return this.table;
    }

    public ToolItem getCheckForUpdatesButton() {
        return this.checkForUpdates;
    }

    public class AddItem {
        private final String display;
        private final Runnable action;

        public AddItem(String display, Runnable action) {
            this.display = display;
            this.action = action;
        }

        public String getDisplayName() {
            return this.display;
        }

        public Runnable getAction() {
            return this.action;
        }
    }

    public class DependencyColumn {
        private final String name;
        private final int width;
        private final Function<IDependency, String> display;
        private final Function<IDependency, Set<String>> values;
        private final ModifyAction update;
        private Optional<CellLabelProvider> labelProvider = Optional.empty();

        public DependencyColumn(String name, int width, Function<IDependency, String> display, ModifyAction update, Function<IDependency, Set<String>> values) {
            this.name = name;
            this.width = width;
            this.display = display;
            this.update = update;
            this.values = values;
        }

        public DependencyColumn(String name, int width, Function<IDependency, String> display, ModifyAction update, Function<IDependency, Set<String>> values, CellLabelProvider labelProvider) {
            this(name, width, display, update, values);
            this.labelProvider = Optional.ofNullable(labelProvider);
        }

        public Function<IDependency, String> getDisplay() {
            return this.display;
        }

        public ModifyAction getUpdate() {
            return this.update;
        }

        public Function<IDependency, Set<String>> getValues() {
            return this.values;
        }

        public int getWidth() {
            return this.width;
        }

        public String getName() {
            return this.name;
        }

        public Optional<CellLabelProvider> getLabelProvider() {
            return this.labelProvider;
        }
    }

    private class DropdownSelectionListener
    extends SelectionAdapter {
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item, final Runnable action) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    action.run();
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            ToolItem item = (ToolItem)event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            this.menu.setLocation(pt.x, pt.y + rect.height);
            this.menu.setVisible(true);
        }
    }

    public static interface ModifyAction {
        public void apply(IDependency var1, String var2);
    }
}

