/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dependencies;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.exchange.ExchangeAsset;

public class SnapshotUpdateDialog
extends MessageDialog {
    private static final String APPLY_LABEL = "Apply";
    private static final String WARNING_MESSAGE = "This update will affect all projects that use this dependency";
    private static final String SNAPSHOT_UPDATE_MESSAGE = "A new snapshot update is available for %s";
    private static final String SNAPSHOT_UPDATE_MESSAGE_WARNING = "The dependency will be updated after you apply changes in the project \nproperties";
    private static final String SNAPSHOT_TITLE = "Checking snapshot";
    private static final String SCAFFOLD_UPDATED_API_CONFIRMATION = "Scaffold updated API";
    private static final String ASSET_NOT_FOUND_MESSAGE = "The asset has not been found in exchange, so there is no possible update to be applied. \nPlease check your login information and permissions";
    private static final String NOT_UPDATES = "There are no possible updates for this API";
    private static boolean shouldScaffold = true;
    private boolean justWarn = false;
    private boolean showScaffoldOption = false;
    private Optional<ExchangeAsset> asset;
    private List<ExchangeAsset> availableVersions;

    private SnapshotUpdateDialog(Shell parentShell, String dialogTitle, boolean showScaffoldOption, String dialogMessage, Optional<ExchangeAsset> asset, List<ExchangeAsset> avaiableVersions) {
        super(parentShell, dialogTitle, null, dialogMessage, 2, 0, new String[0]);
        this.showScaffoldOption = showScaffoldOption;
        this.asset = asset;
        this.availableVersions = avaiableVersions;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        HashSet buttons = Sets.newHashSet();
        if (!this.availableVersions.isEmpty()) {
            buttons.add(this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false));
        }
        buttons.add(this.createButton(parent, 0, !this.availableVersions.isEmpty() ? APPLY_LABEL : IDialogConstants.OK_LABEL, this.availableVersions.isEmpty()));
        this.setButtons(buttons.toArray(new Button[0]));
    }

    public static int openUpdateSnapshotDialog(Shell shell, Optional<ExchangeAsset> asset, List<ExchangeAsset> availableVersions) {
        SnapshotUpdateDialog dialog = new SnapshotUpdateDialog(shell, SNAPSHOT_TITLE, true, SnapshotUpdateDialog.resolveMessage(asset, availableVersions, SNAPSHOT_UPDATE_MESSAGE), asset, availableVersions);
        return dialog.open();
    }

    public static int openUpdateSnapshotDialogExtendeed(Shell shell, Optional<ExchangeAsset> asset, List<ExchangeAsset> availableVersions) {
        String message = "A new snapshot update is available for %s \nThe dependency will be updated after you apply changes in the project \nproperties";
        SnapshotUpdateDialog dialog = new SnapshotUpdateDialog(shell, SNAPSHOT_TITLE, false, SnapshotUpdateDialog.resolveMessage(asset, availableVersions, message), asset, availableVersions);
        return dialog.open();
    }

    public static int openUpdateSnapshotWarningDialog(Shell shell, Optional<ExchangeAsset> asset) {
        String message = "A new snapshot update is available for %s \nThe dependency will be updated after you apply changes in the project \nproperties";
        List<ExchangeAsset> singletonList = Collections.singletonList(asset.get());
        SnapshotUpdateDialog dialog = new SnapshotUpdateDialog(shell, SNAPSHOT_TITLE, false, SnapshotUpdateDialog.resolveMessage(asset, singletonList, message), asset, Collections.emptyList());
        dialog.justWarn = true;
        return dialog.open();
    }

    private static String resolveMessage(Optional<ExchangeAsset> asset, List<ExchangeAsset> availableVersions, String messageContent) {
        if (availableVersions.isEmpty()) {
            return NOT_UPDATES;
        }
        return asset.map(s -> String.format(messageContent, s.getName() + " " + s.getVersion())).orElse(ASSET_NOT_FOUND_MESSAGE);
    }

    protected Control createMessageArea(Composite composite) {
        Control createMessageArea = super.createMessageArea(composite);
        if (this.asset.isPresent() && !this.availableVersions.isEmpty() || this.justWarn) {
            Composite messageComposite = (Composite)createMessageArea;
            Composite genericMessageComposite = new Composite(messageComposite, 0);
            GridLayoutFactory.fillDefaults().margins(43, 0).applyTo(genericMessageComposite);
            Label detailedGenericMessage = new Label(genericMessageComposite, 64);
            detailedGenericMessage.setText(WARNING_MESSAGE);
            if (this.showScaffoldOption) {
                Button scaffoldCheckbox = new Button(genericMessageComposite, 32);
                scaffoldCheckbox.setText(SCAFFOLD_UPDATED_API_CONFIRMATION);
                scaffoldCheckbox.setSelection(shouldScaffold);
                scaffoldCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.onScaffoldToggle(scaffoldCheckbox.getSelection())));
                GridDataFactory.fillDefaults().indent(0, 20).align(16384, 0x1000000).applyTo((Control)scaffoldCheckbox);
            }
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)detailedGenericMessage);
            GridDataFactory.fillDefaults().align(1, 1).span(2, 1).applyTo((Control)genericMessageComposite);
        }
        return createMessageArea;
    }

    private void onScaffoldToggle(boolean selection) {
        shouldScaffold = selection;
    }

    public static boolean scaffoldApi() {
        return shouldScaffold;
    }
}

