/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.core;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.ui.IChangesPushedToVcsListener;
import org.mule.tooling.ui.authentication.utils.IStudioLoginRequired;
import org.mule.tooling.ui.core.JDKHttpConnection;
import org.mule.tooling.ui.core.StudioPerspectiveSwitch;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class UIStartup
implements IStartup {
    private static final String SETTING_HTTP_HEADERS = "Setting studio HTTP headers";
    private static final String USER_NOT_LOGGED_TITLE = "User not logged in";
    private static final String USER_NOT_LOGGED_IN = "No user is currently logged in or token is Expired. Please login to Anypoint Platform to run operations";
    private static final String TRACK_ID = "Executing git operation";
    private boolean pushNotificationSent = false;

    public void earlyStartup() {
        Job setAuthJob = Job.createSystem((String)SETTING_HTTP_HEADERS, monitor -> {
            this.setHttpAuthenticationHeaders();
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                this.addPartListener(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                this.addPerspectiveListener(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            });
        });
        setAuthJob.setPriority(20);
        setAuthJob.schedule();
    }

    public void setHttpAuthenticationHeaders() {
        HttpTransport.setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory(){
            HttpConnectionFactory defaultFactory = HttpTransport.getConnectionFactory();

            public HttpConnection create(URL url, Proxy proxy) throws IOException {
                if (this.isApiVcsEndpoint(url).booleanValue()) {
                    UIStartup.this.sendPushEventInApiProjectIfNeccessary(url.toString());
                    JDKHttpConnection jdkConnection = new JDKHttpConnection(url, proxy);
                    this.setBearerToken(jdkConnection);
                    return jdkConnection;
                }
                return this.defaultFactory.create(url, proxy);
            }

            public HttpConnection create(URL url) throws IOException {
                if (this.isApiVcsEndpoint(url).booleanValue()) {
                    JDKHttpConnection jdkConnection = new JDKHttpConnection(url);
                    this.setBearerToken(jdkConnection);
                    return jdkConnection;
                }
                return this.defaultFactory.create(url);
            }

            private Boolean isApiVcsEndpoint(URL url) {
                return url.toString().startsWith(PlatformUrls.getDesignCenterGitEndpoint());
            }

            private void setBearerToken(final JDKHttpConnection jdkConnection) {
                final ObjectHolder loginSuccess = new ObjectHolder();
                IStudioLoginRequired loginRequired = new IStudioLoginRequired(){

                    public void onAfterSuccessfulLogin(AuthUser activeUser) {
                        loginSuccess.set((Object)true);
                        jdkConnection.setRequestProperty("Authorization", "Bearer " + activeUser.getToken());
                    }

                    public void onAfterFailedLogin() {
                        loginSuccess.set((Object)false);
                        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell().getShell();
                        MuleCorePlugin.openError((Shell)activeShell, (String)UIStartup.USER_NOT_LOGGED_TITLE, (String)UIStartup.USER_NOT_LOGGED_IN);
                    }
                };
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> loginRequired.runRequiringLogin(UIStartup.TRACK_ID));
                if (loginSuccess.get() != null && !((Boolean)loginSuccess.get()).booleanValue()) {
                    throw new OperationCanceledException(UIStartup.USER_NOT_LOGGED_IN);
                }
            }
        });
    }

    private void sendPushEventInApiProjectIfNeccessary(String url) {
        if (!this.pushNotificationSent && url.contains("git-receive-pack")) {
            this.pushNotificationSent = true;
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new IEvent<IChangesPushedToVcsListener>(){

                public EventType<IChangesPushedToVcsListener> getAssociatedType() {
                    return IChangesPushedToVcsListener.ON_CHANGES_PUSHED_TO_VCS;
                }

                public void dispatch(IChangesPushedToVcsListener handler) {
                    handler.onChangesPushedToVcs();
                }
            });
        } else {
            this.pushNotificationSent = false;
        }
    }

    private void addPartListener(final IWorkbenchWindow window) {
        if (window != null) {
            window.getPartService().addPartListener(new IPartListener2(){

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    super.partBroughtToTop(partRef);
                    if (StudioPerspectiveSwitch.shouldSwitchPerspective(partRef, window)) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> StudioPerspectiveSwitch.showPerspectiveByEditorAndProjectNature(partRef, window));
                    }
                }
            });
        }
    }

    private void addPerspectiveListener(IWorkbenchWindow window) {
        if (window != null) {
            window.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                }

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> StudioPerspectiveSwitch.hideUnrequiredViews(perspective.getId()));
                }
            });
        }
    }
}

