/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.core;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.preferences.PerspectivePreferences;

public class StudioPerspectiveSwitch {
    private static final String IS_EDITOR_REGEX = "org.eclipse.ui.genericeditor.GenericEditor|org.mule.tooling.messageflow.messageFlowEditor|org.eclipse.jdt.ui.CompilationUnitEditor|org.mule.tooling.apidesigner.exchangeJsonEditor|org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart|org.eclipse.jdt.ui.CompilationUnitEditor|org.mule.tooling.domain.xmlEditor|org.mule.tooling.ui.contribution.munit.editors.MunitMultiPageEditor";
    private static final Pattern IS_EDITOR_PATTERN = Pattern.compile("org.eclipse.ui.genericeditor.GenericEditor|org.mule.tooling.messageflow.messageFlowEditor|org.eclipse.jdt.ui.CompilationUnitEditor|org.mule.tooling.apidesigner.exchangeJsonEditor|org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart|org.eclipse.jdt.ui.CompilationUnitEditor|org.mule.tooling.domain.xmlEditor|org.mule.tooling.ui.contribution.munit.editors.MunitMultiPageEditor");
    private static final String ERROR_GETTING_PERSPECTIVE_BY_PROJECT_TYPE = "There was an error while trying to get the project type for perspective switching";
    private static final String ERROR_SWITCHING_PERSPECTIVE = "There was an error while trying to switch perspectives";
    private static final String MULE_PROPERTIES_VIEW_ID = "org.mule.tooling.properties.views.MulePropertiesView";

    private StudioPerspectiveSwitch() {
    }

    private static void perspectiveSwitch(String perspectiveToSwitch, IWorkbenchWindow window) {
        IPreferenceStore prefs = MuleUIPlugin.getDefault().getPreferenceStore();
        String projectSwitchPreferenceKey = PerspectivePreferences.getPreferenceStoreKeyByPerspectiveID(perspectiveToSwitch);
        String projectSwitchPreferenceValue = prefs.getString(projectSwitchPreferenceKey);
        IWorkbenchPage page = window.getActivePage();
        if ("prompt".equals(projectSwitchPreferenceValue)) {
            IWorkbench workbench = window.getWorkbench();
            IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
            IPerspectiveDescriptor descriptor = registry.findPerspectiveWithId(perspectiveToSwitch);
            if (page != null && page.getPerspective() != descriptor) {
                MessageDialogWithToggle dialog = StudioPerspectiveSwitch.generatePerspectiveSwitchDialog(perspectiveToSwitch, window, prefs, projectSwitchPreferenceValue, false);
                if (dialog.getReturnCode() == 2) {
                    StudioPerspectiveSwitch.showPerspective(perspectiveToSwitch, window);
                    if (dialog.getToggleState()) {
                        prefs.setValue(projectSwitchPreferenceKey, "always");
                    }
                } else if (dialog.getToggleState()) {
                    prefs.setValue(projectSwitchPreferenceKey, "never");
                }
            }
        } else if ("always".equals(projectSwitchPreferenceValue)) {
            StudioPerspectiveSwitch.showPerspective(perspectiveToSwitch, window);
        }
    }

    private static void showPerspective(String perspectiveToSwitch, IWorkbenchWindow window) {
        try {
            PlatformUI.getWorkbench().showPerspective(perspectiveToSwitch, window);
        }
        catch (WorkbenchException e) {
            MuleCorePlugin.logError((String)ERROR_SWITCHING_PERSPECTIVE, (Throwable)e);
        }
    }

    public static void hideUnrequiredViews(String perspectiveToSwitch) {
        if (perspectiveToSwitch.equals("org.mule.tooling.ui.apiproject.perspective")) {
            StudioPerspectiveSwitch.hideView(MULE_PROPERTIES_VIEW_ID);
        }
    }

    private static void hideView(String viewId) {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
        if (view != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(view);
        }
    }

    private static MessageDialogWithToggle generatePerspectiveSwitchDialog(String perspectiveToSwitch, IWorkbenchWindow window, IPreferenceStore prefs, String projectSwitchPreference, boolean rememberPreferenceSetting) {
        return MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)"Confirm Perspective Switch", (String)("This type of project is associated with the " + PerspectivePreferences.getPerspectiveNameByID(perspectiveToSwitch) + " perspective. Do you want to switch to this perspective now?"), (String)"Remember my decision", (boolean)rememberPreferenceSetting, (IPreferenceStore)prefs, (String)projectSwitchPreference);
    }

    private static boolean isEditor(String id) {
        return IS_EDITOR_PATTERN.matcher(id).matches();
    }

    private static boolean isSdkProject(IEditorInput input) {
        try {
            IResource resource = (IResource)input.getAdapter(IResource.class);
            return CoreUtils.hasSDKNature((IProject)resource.getProject());
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)ERROR_GETTING_PERSPECTIVE_BY_PROJECT_TYPE, (Throwable)e);
            return false;
        }
    }

    private static String getPerspectiveIDByResourceType(IResource resource) {
        if (MuleResourceUtils.isConfigFile((IResource)resource, (String)MuleProjectKind.APPLICATION.getXmlRootNodeName())) {
            return "org.mule.tooling.ui.toolingPerspective";
        }
        return "org.eclipse.jdt.ui.JavaPerspective";
    }

    private static String getPerspectiveIDByProjectType(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource != null && resource.getProject().isAccessible()) {
            IProject project;
            block8: {
                block7: {
                    project = resource.getProject();
                    if (!CoreUtils.hasNature((IProject)project, (String)"org.mule.tooling.apidesigner.apiprojectnature")) break block7;
                    return "org.mule.tooling.ui.apiproject.perspective";
                }
                if (CoreUtils.hasNature((IProject)project, (String)"org.mule.tooling.sdk.sdkNature")) {
                    return StudioPerspectiveSwitch.getPerspectiveIDByResourceType(resource);
                }
                if (!CoreUtils.hasNature((IProject)project, (String)"org.mule.tooling.core.muleStudioNature")) break block8;
                return "org.mule.tooling.ui.toolingPerspective";
            }
            try {
                if (CoreUtils.hasNature((IProject)project, (String)"org.eclipse.jdt.core.javanature")) {
                    return "org.eclipse.jdt.ui.JavaPerspective";
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)ERROR_GETTING_PERSPECTIVE_BY_PROJECT_TYPE, (Throwable)e);
            }
        }
        return "";
    }

    public static boolean shouldSwitchPerspective(IWorkbenchPartReference partRef, IWorkbenchWindow window) {
        return !Boolean.getBoolean("studio.test") && !"org.mule.tooling.ui.debugPerspective".equals(window.getActivePage().getPerspective().getId()) && StudioPerspectiveSwitch.isEditor(partRef.getId());
    }

    public static void showPerspectiveByEditorAndProjectNature(IWorkbenchPartReference partRef, IWorkbenchWindow window) {
        String perspectiveToSwitch;
        IEditorPart activeEditor = partRef.getPage().getActiveEditor();
        String string = perspectiveToSwitch = activeEditor != null ? StudioPerspectiveSwitch.getPerspectiveIDByProjectType(activeEditor.getEditorInput()) : "";
        if (!perspectiveToSwitch.isEmpty() && !perspectiveToSwitch.equals(window.getActivePage().getPerspective().getId())) {
            if (StudioPerspectiveSwitch.isSdkProject(activeEditor.getEditorInput())) {
                StudioPerspectiveSwitch.showPerspective(perspectiveToSwitch, window);
            } else {
                StudioPerspectiveSwitch.perspectiveSwitch(perspectiveToSwitch, window);
            }
        }
    }
}

