/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;

public class StudioAnalyticsIdStore {
    private static String STUDIO_STATIC_ID;
    public static String STUDIO_ID_FILENAME;
    private static final String INSTALLATION_DIR;

    static {
        STUDIO_ID_FILENAME = ".studio_analytics_id.txt";
        INSTALLATION_DIR = System.getProperty("user.dir");
    }

    public static String getCurrentId() {
        if (STUDIO_STATIC_ID == null) {
            StudioAnalyticsIdStore.loadValue();
        }
        return STUDIO_STATIC_ID;
    }

    private static void loadValue() {
        IPath analyticsFile = StudioAnalyticsIdStore.getStudioAnalyticsIdFile();
        if (analyticsFile != null) {
            File analyticsIdFile = analyticsFile.toFile();
            if (analyticsIdFile.exists()) {
                try {
                    STUDIO_STATIC_ID = FileUtils.readFileToString((File)analyticsIdFile, (String)StandardCharsets.UTF_8.name());
                }
                catch (IOException e) {
                    MuleCorePlugin.logError((String)"Could not read analytics file", (Throwable)e);
                }
            } else {
                STUDIO_STATIC_ID = UUID.randomUUID().toString();
                StudioAnalyticsIdStore.save();
            }
        }
    }

    private static void save() {
        IPath analyticsFile = StudioAnalyticsIdStore.getStudioAnalyticsIdFile();
        if (analyticsFile != null) {
            File analyticsIdFile = analyticsFile.toFile();
            try {
                FileUtils.writeStringToFile((File)analyticsIdFile, (String)STUDIO_STATIC_ID, (String)StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)"Could not read analytics file", (Throwable)e);
            }
        }
    }

    private static IPath getStudioAnalyticsIdFile() {
        IPath location = null;
        Path baseLocation = new Path(INSTALLATION_DIR);
        if (baseLocation != null) {
            location = baseLocation.append((IPath)new Path(STUDIO_ID_FILENAME));
        }
        return location;
    }

    public static File getStudioAnalyticsFile() {
        return StudioAnalyticsIdStore.getStudioAnalyticsIdFile().toFile();
    }
}

