/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.utils.RuntimeUpdateDialogUtils;

public class MuleRuntimeClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private static final String TITLE_VERSION_CHANGE = "Mule Runtime Version Change";
    private static final String MESSAGE_INCOMPATIBILITY = "You will change the project Mule runtime version. For AsyncAPI implementations, select Mule runtime 4.6 or later. Do you want to proceed?\n";
    private static final String PROJECT_IN_DOMAIN_MESSAGE = "This project belongs to a domain.\nThe runtime settings can be specified in the domain project's settings or in the Build Path settings.";
    private static final String ALREADY_CONFIGURED_MESSAGE = "There is already a Runtime configured for this project.\nYou can either edit it through the Build Path dialog or through the project settings.";
    private static final String[] LABELS = new String[]{"Proceed", "Cancel"};
    private ServerChooserComponent serverChooserComponent;
    private IJavaProject javaProject;
    private IClasspathEntry originalEntry;

    public MuleRuntimeClasspathContainerPage() {
        super("Mule Runtime Classpath Container", "Mule Runtime for Anypoint Studio", null);
        this.setDescription("Mule Runtime Classpath Container");
        this.setPageComplete(true);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
    }

    private boolean hasMuleRuntime(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (MuleClasspathContainer.isMuleRuntime((IClasspathEntry)entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.originalEntry = containerEntry;
    }

    public void createControl(Composite parent) {
        if (this.originalEntry != null) {
            this.createControlsForEdition(parent);
        } else {
            this.createControlsForAddition(parent);
        }
        this.setControl((Control)parent);
    }

    private void createControlsForAddition(Composite parent) {
        try {
            boolean hasMuleRuntime = this.hasMuleRuntime(this.javaProject);
            if (this.isMuleProject(this.javaProject)) {
                boolean isInDomain = this.isInDomain(this.javaProject);
                if (!isInDomain && !hasMuleRuntime) {
                    this.doCreateControls(parent);
                } else {
                    Label alreadyConfiguredLabel = new Label(parent, 0);
                    alreadyConfiguredLabel.setText(isInDomain ? PROJECT_IN_DOMAIN_MESSAGE : ALREADY_CONFIGURED_MESSAGE);
                }
            } else if (!hasMuleRuntime) {
                this.doCreateControls(parent);
            } else {
                Label alreadyConfiguredLabel = new Label(parent, 0);
                alreadyConfiguredLabel.setText(ALREADY_CONFIGURED_MESSAGE);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem trying to determine if there is already a runtime configured for project: " + this.javaProject.getProject().getName()), (Throwable)e);
        }
    }

    private boolean isInDomain(IJavaProject javaProject) throws CoreException {
        return CoreUtils.getDomainProject((IMuleProject)MuleRuntime.create((IProject)javaProject.getProject())) != null;
    }

    private boolean isMuleProject(IJavaProject javaProject) throws CoreException {
        return CoreUtils.hasMuleNature((IProject)javaProject.getProject());
    }

    private void createControlsForEdition(Composite parent) {
        try {
            if (this.isMuleProject(this.javaProject)) {
                boolean isInDomain = this.isInDomain(this.javaProject);
                if (!isInDomain) {
                    this.doCreateControlsForEdition(parent);
                } else {
                    Label alreadyConfiguredLabel = new Label(parent, 0);
                    alreadyConfiguredLabel.setText(PROJECT_IN_DOMAIN_MESSAGE);
                }
            } else {
                this.doCreateControlsForEdition(parent);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem trying to determine if the project " + this.javaProject.getProject().getName() + " belongs to a domain."), (Throwable)e);
        }
    }

    private void doCreateControlsForEdition(Composite parent) {
        this.doCreateControls(parent);
        String runtimeId = MuleClasspathContainer.getRuntimeId((IClasspathEntry)this.originalEntry);
        if (MuleCorePlugin.getServerManager().containsServerDefinition(runtimeId)) {
            IServerDefinition serverDefinition = MuleCorePlugin.getServerManager().getServerDefinition(runtimeId);
            this.serverChooserComponent.setServerDefinition(serverDefinition);
        }
    }

    private void doCreateControls(Composite parent) {
        Composite editionComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)editionComposite);
        GridLayoutFactory.fillDefaults().applyTo(editionComposite);
        editionComposite.setFont(parent.getFont());
        this.serverChooserComponent = new ServerChooserComponent("Choose a Server version");
        Control serverChooserControl = this.serverChooserComponent.createControl(editionComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(serverChooserControl);
    }

    public boolean finish() {
        block5: {
            if (this.validState()) {
                IMuleProject muleProject;
                block6: {
                    MessageDialog messageDialog;
                    int acceptQuestion;
                    muleProject = MuleRuntime.create((IProject)this.javaProject.getProject());
                    if (!(muleProject instanceof BaseMuleProject)) break block5;
                    if (CoreUtils.isRuntimeCompatibleWithAsyncAPI((List)muleProject.getDeclaredDependencies(), (IServerDefinition)this.serverChooserComponent.getServerDefinition()) || (acceptQuestion = (messageDialog = new MessageDialog(this.getShell(), TITLE_VERSION_CHANGE, null, MESSAGE_INCOMPATIBILITY, 4, LABELS, 0)).open()) != 1) break block6;
                    return false;
                }
                try {
                    ((BaseMuleProject)muleProject).changeRuntime(this.getSelectedRuntimeId(), false);
                    if (RuntimeUpdateDialogUtils.showUpdateRuntimeDialog()) {
                        CoreUtils.updateFieldInMuleArtifactJson((File)muleProject.getMuleArtifactFile().getLocation().toFile(), (String)"minMuleVersion", (Object)this.serverChooserComponent.getServerDefinition().getVersionWithPatchVersionZero());
                    }
                }
                catch (IOException | CoreException e) {
                    MuleCorePlugin.logError((String)("There was a problem updating the runtime for project " + this.javaProject.getProject().getName()), (Throwable)e);
                }
            }
        }
        return true;
    }

    private boolean validState() {
        return this.serverChooserComponent != null;
    }

    private String getSelectedRuntimeId() {
        return this.serverChooserComponent.getServerDefinition().getId();
    }

    public IClasspathEntry getSelection() {
        if (this.validState()) {
            return JavaCore.newContainerEntry((IPath)MuleClasspathContainer.buildContainerPath((String)this.getSelectedRuntimeId()));
        }
        return null;
    }
}

