/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.MessageDialogUtils;

public class JDKHttpConnection
implements HttpConnection {
    HttpURLConnection wrappedUrlConnection;
    private static final int MAX_RETRIES = 3;
    private static final String ERROR_TITLE = "Endpoint API error";
    private static final String ERROR_DEFAULT_MESSAGE = "There was an error while trying to communicate with the API endpoint:";
    private static final String ERROR_API_ERROR_CODE_HEADER = "Error code: ";
    private static final String ERROR_UNDEFINED_CODE = "Please check below error code and message for more information.";
    private static final String ERROR_401 = "Authentication failed. This could be due to a wrong user/password combination or an expired token. Please try logging in again and check you have the correct permissions.";
    private static final String ERROR_403 = "The currently logged in user does not have permissions to access the resource.";
    private static final String ERROR_404 = "The resource was not found. The API might have been deleted from MuleSoft VCS. Please check if it is available.";
    private static final String ERROR_423 = "The project seems to be locked remotely. Please check that no publish operations are currently in progress or try closing instances from MuleSoft VCS webpage that may be locking the project and try again.";
    private static final String ERROR_502 = "Invalid response from server. Please try again.";
    private static final String ERROR_503 = "Service not available. The server may be temporarily down or under maintenance. Please try again later.";

    private String errorMessageBuilder(String errorMessage, int responseCode, String responseMessage) {
        return errorMessage + "\nError code: " + String.valueOf(responseCode) + " " + responseMessage;
    }

    private String errorMessageBuilder(String errorMessage) {
        return "There was an error while trying to communicate with the API endpoint:\n" + errorMessage + "\n";
    }

    JDKHttpConnection(HttpURLConnection urlConnection) {
        this.wrappedUrlConnection = urlConnection;
    }

    protected JDKHttpConnection(URL url) throws MalformedURLException, IOException {
        this.wrappedUrlConnection = (HttpURLConnection)url.openConnection();
    }

    protected JDKHttpConnection(URL url, Proxy proxy) throws MalformedURLException, IOException {
        this.wrappedUrlConnection = (HttpURLConnection)url.openConnection(proxy);
    }

    public int getResponseCode() throws IOException {
        int retryCounter = 0;
        int responseCode = -1;
        String responseMessage = "";
        while (retryCounter < 3) {
            try {
                if (retryCounter > 0) {
                    this.wrappedUrlConnection.disconnect();
                    this.wrappedUrlConnection.connect();
                }
                responseCode = this.wrappedUrlConnection.getResponseCode();
                responseMessage = this.getResponseMessage();
                switch (responseCode) {
                    case 401: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_401, responseCode, responseMessage));
                    }
                    case 403: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_403, responseCode, responseMessage));
                    }
                    case 404: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_404, responseCode, responseMessage));
                    }
                    case 423: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_423, responseCode, responseMessage));
                    }
                    case 502: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_502, responseCode, responseMessage));
                    }
                    case 503: {
                        throw new OperationCanceledException(this.errorMessageBuilder(ERROR_503, responseCode, responseMessage));
                    }
                }
                if (responseCode == 200) break;
                throw new OperationCanceledException(this.errorMessageBuilder(ERROR_UNDEFINED_CODE, responseCode, responseMessage));
            }
            catch (Exception e) {
                if (++retryCounter < 3) continue;
                String message = e.getCause() == null ? this.errorMessageBuilder(e.getMessage()) : this.errorMessageBuilder(e.getCause().toString());
                MuleCorePlugin.logError((String)message, (Throwable)e);
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> MessageDialogUtils.openErrorWithLinkToLogView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ERROR_TITLE, message));
                throw e;
            }
        }
        return responseCode;
    }

    public URL getURL() {
        return this.wrappedUrlConnection.getURL();
    }

    public String getResponseMessage() throws IOException {
        return this.wrappedUrlConnection.getResponseMessage();
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.wrappedUrlConnection.getHeaderFields();
    }

    public void setRequestProperty(String key, String value) {
        this.wrappedUrlConnection.setRequestProperty(key, value);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.wrappedUrlConnection.setRequestMethod(method);
    }

    public void setUseCaches(boolean usecaches) {
        this.wrappedUrlConnection.setUseCaches(usecaches);
    }

    public void setConnectTimeout(int timeout) {
        this.wrappedUrlConnection.setConnectTimeout(timeout);
    }

    public void setReadTimeout(int timeout) {
        this.wrappedUrlConnection.setReadTimeout(timeout);
    }

    public String getContentType() {
        return this.wrappedUrlConnection.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrappedUrlConnection.getInputStream();
    }

    public String getHeaderField(@NonNull String name) {
        return this.wrappedUrlConnection.getHeaderField(name);
    }

    public List<String> getHeaderFields(@NonNull String name) {
        Map<String, List<String>> m = this.wrappedUrlConnection.getHeaderFields();
        List<String> fields = JDKHttpConnection.mapValuesToListIgnoreCase(name, m);
        return fields;
    }

    private static List<String> mapValuesToListIgnoreCase(String keyName, Map<String, List<String>> m) {
        LinkedList<String> fields = new LinkedList<String>();
        m.entrySet().stream().filter(e -> keyName.equalsIgnoreCase((String)e.getKey())).filter(e -> e.getValue() != null).forEach(e -> {
            boolean bl = fields.addAll((Collection)e.getValue());
        });
        return fields;
    }

    public int getContentLength() {
        return this.wrappedUrlConnection.getContentLength();
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.wrappedUrlConnection.setInstanceFollowRedirects(followRedirects);
    }

    public void setDoOutput(boolean dooutput) {
        this.wrappedUrlConnection.setDoOutput(dooutput);
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        this.wrappedUrlConnection.setFixedLengthStreamingMode(contentLength);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.wrappedUrlConnection.getOutputStream();
    }

    public void setChunkedStreamingMode(int chunklen) {
        this.wrappedUrlConnection.setChunkedStreamingMode(chunklen);
    }

    public String getRequestMethod() {
        return this.wrappedUrlConnection.getRequestMethod();
    }

    public boolean usingProxy() {
        return this.wrappedUrlConnection.usingProxy();
    }

    public void connect() throws IOException {
        this.wrappedUrlConnection.connect();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameverifier) {
        ((HttpsURLConnection)this.wrappedUrlConnection).setHostnameVerifier(hostnameverifier);
    }

    public void configure(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(km, tm, random);
        ((HttpsURLConnection)this.wrappedUrlConnection).setSSLSocketFactory(ctx.getSocketFactory());
    }
}

