/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class ServerComboChooserComponent
implements WizardPagePartExtension {
    public static final String KEY_SERVER_DEFINITION = "serverDefinition";
    @WizardContext
    private PartStatusHandler statusHandler;
    private static final String NO_SERVERS_AVAILABLE = "There are no Mule Servers installed";
    private static final String NO_SERVERS_EE_AVAILABLE = "There are no Mule EE Servers installed";
    private List<IServerDefinition> serverDefinitions;
    private ComboViewer runtimesCombo;
    @WizardContext
    private IServerDefinition serverDefinition;
    private String groupTitle;
    private boolean onlyEE;

    public ServerComboChooserComponent() {
        this("Runtime", false);
    }

    public ServerComboChooserComponent(boolean onlyEE) {
        this("Runtime", onlyEE);
    }

    public ServerComboChooserComponent(String groupTitle) {
        this(groupTitle, false);
    }

    public ServerComboChooserComponent(String groupTitle, boolean onlyEE) {
        this.onlyEE = onlyEE;
        this.serverDefinitions = this.getServerDefinitions();
        this.groupTitle = groupTitle;
        this.statusHandler = new NaiveStatusHandler();
    }

    private List<IServerDefinition> getServerDefinitions() {
        if (this.isOnlyEE()) {
            return CoreUtils.getEEServers();
        }
        return MuleCorePlugin.getServerManager().getServerDefinitions();
    }

    @Override
    public Control createControl(Composite container) {
        Group serverGroup = UiUtils.createGroupWithTitle(container, this.groupTitle, 1);
        if (!this.serverDefinitions.isEmpty()) {
            this.createServersTable(serverGroup);
        } else {
            Label noServersMessage = new Label((Composite)serverGroup, 0);
            noServersMessage.setText(this.isOnlyEE() ? NO_SERVERS_EE_AVAILABLE : NO_SERVERS_AVAILABLE);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)noServersMessage);
        }
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)serverGroup.getLayout())).spacing(LayoutConstants.getSpacing().x, LayoutConstants.getSpacing().y / 2 * 3).applyTo((Composite)serverGroup);
        return serverGroup;
    }

    private void setDefaultServerSelection() {
        IServerDefinition[] items = (IServerDefinition[])this.runtimesCombo.getInput();
        if (items.length > 0) {
            IServerDefinition defaultRuntime = new MuleStudioPreference().getDefaultRuntimeSelection();
            this.runtimesCombo.setSelection((ISelection)new StructuredSelection((Object)defaultRuntime), true);
        }
    }

    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    public void setServerDefinition(IServerDefinition serverDefinition) {
        if (this.serverDefinitions.contains(serverDefinition)) {
            this.serverDefinition = serverDefinition;
            this.setSelectedServerDefinition(serverDefinition);
        }
    }

    private void setSelectedServerDefinition(IServerDefinition serverDefinition) {
        this.runtimesCombo.setSelection((ISelection)new StructuredSelection((Object)serverDefinition));
    }

    private void createServersTable(Group serverGroup) {
        this.runtimesCombo = new ComboViewer((Composite)serverGroup);
        this.runtimesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runtimesCombo.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
        this.runtimesCombo.setComparator(this.createComparator());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.runtimesCombo.getCombo());
        this.runtimesCombo.setInput(this.serverDefinitions);
        this.runtimesCombo.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                this.onListSelectionChanged(structuredSelection);
            }
        });
    }

    private ViewerComparator createComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IServerDefinition serverDefinition1 = (IServerDefinition)e1;
                IServerDefinition serverDefinition2 = (IServerDefinition)e2;
                return serverDefinition2.compareTo((Object)serverDefinition1);
            }
        };
    }

    void addClabel(Composite composite, String text, Image image) {
        CLabel onpremLabel = new CLabel(composite, 0);
        onpremLabel.setText(text);
        onpremLabel.setImage(image);
        GridDataFactory.swtDefaults().hint(-1, image.getImageData().height).applyTo((Control)onpremLabel);
    }

    void onListSelectionChanged(IStructuredSelection structuredSelection) {
        boolean selectionNotEmpty = !structuredSelection.isEmpty();
        this.statusHandler.setPartComplete(this, selectionNotEmpty);
        if (selectionNotEmpty) {
            this.onServerChanged((IServerDefinition)structuredSelection.getFirstElement());
            this.statusHandler.clearErrors(this);
        } else {
            this.onServerChanged(null);
            this.statusHandler.setErrorMessage(this, "Please select a Mule Server");
        }
    }

    private void onServerChanged(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.statusHandler.notifyUpdate(this, KEY_SERVER_DEFINITION, serverDefinition);
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public void initializeDefaults() {
        if (!this.serverDefinitions.isEmpty()) {
            this.setDefaultServerSelection();
        }
    }

    public boolean isOnlyEE() {
        return this.onlyEE;
    }

    public void setOnlyEE(boolean onlyEE) {
        this.onlyEE = onlyEE;
    }
}

