/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.common.InstallRuntimeLinkComponent;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class ServerChooserComponent
implements WizardPagePartExtension {
    public static final String KEY_SERVER_DEFINITION = "serverDefinition";
    @WizardContext
    private PartStatusHandler statusHandler;
    private static final String NO_SERVERS_AVAILABLE = "There are no Mule Servers installed";
    private List<IServerDefinition> serverDefinitions;
    private TableViewer runtimesTable;
    @WizardContext
    private IServerDefinition serverDefinition;
    private String groupTitle;

    public ServerChooserComponent() {
        this(ServerChooserComponent.getServerDefinitions(), "Runtime");
    }

    public ServerChooserComponent(List<IServerDefinition> serverDefinitions) {
        this(serverDefinitions, "Runtime");
    }

    public ServerChooserComponent(String groupTitle) {
        this(ServerChooserComponent.getServerDefinitions(), groupTitle);
    }

    public ServerChooserComponent(List<IServerDefinition> serverDefinitions, String groupTitle) {
        this.serverDefinitions = serverDefinitions;
        this.groupTitle = groupTitle;
        this.statusHandler = new NaiveStatusHandler();
    }

    static List<IServerDefinition> getServerDefinitions() {
        return MuleCorePlugin.getServerManager().getServerDefinitions();
    }

    @Override
    public Control createControl(Composite container) {
        Group serverGroup = UiUtils.createGroupWithTitle(container, this.groupTitle, 1);
        WidgetUtils.setFontStyle((Control)serverGroup, (int)1);
        if (!this.serverDefinitions.isEmpty() && this.serverDefinitions.size() > 0) {
            this.createServersTable(serverGroup);
        } else {
            Label noServersMessage = new Label((Composite)serverGroup, 0);
            noServersMessage.setText(NO_SERVERS_AVAILABLE);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)noServersMessage);
        }
        Control installRuntimeControl = new InstallRuntimeLinkComponent().createControl((Composite)serverGroup);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo(installRuntimeControl);
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)serverGroup.getLayout())).spacing(LayoutConstants.getSpacing().x, LayoutConstants.getSpacing().y / 2 * 3).applyTo((Composite)serverGroup);
        serverGroup.layout();
        return serverGroup;
    }

    private void setDefaultServerSelection() {
        TableItem[] items = this.runtimesTable.getTable().getItems();
        if (items.length > 0) {
            IServerDefinition defaultRuntime = new MuleStudioPreference().getDefaultRuntimeSelection();
            this.runtimesTable.setSelection((ISelection)new StructuredSelection((Object)defaultRuntime), true);
        }
    }

    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    public void setServerDefinition(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.setSelectedServerDefinition(serverDefinition);
    }

    private void setSelectedServerDefinition(IServerDefinition serverDefinition) {
        this.runtimesTable.setSelection((ISelection)new StructuredSelection((Object)serverDefinition));
    }

    private void createServersTable(Group serverGroup) {
        this.runtimesTable = new TableViewer((Composite)serverGroup, 68100);
        this.runtimesTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runtimesTable.setLabelProvider((IBaseLabelProvider)new MuleLabelProvider());
        this.runtimesTable.setComparator(this.createComparator());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.runtimesTable.getTable());
        WidgetUtils.createColumn((TableViewer)this.runtimesTable, (String)"runtime", element -> {
            IServerDefinition serverDefinition = (IServerDefinition)element;
            return serverDefinition.getLabel();
        });
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.runtimesTable.getTable().setLayout((Layout)layout);
        this.runtimesTable.setInput(this.serverDefinitions);
        this.runtimesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    ServerChooserComponent.this.onListSelectionChanged(structuredSelection);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.runtimesTable);
    }

    private ViewerComparator createComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IServerDefinition serverDefinition1 = (IServerDefinition)e1;
                IServerDefinition serverDefinition2 = (IServerDefinition)e2;
                return serverDefinition2.compareTo((Object)serverDefinition1);
            }
        };
    }

    void addClabel(Composite composite, String text, Image image) {
        CLabel onpremLabel = new CLabel(composite, 0);
        onpremLabel.setText(text);
        onpremLabel.setImage(image);
        GridDataFactory.swtDefaults().hint(-1, image.getImageData().height).applyTo((Control)onpremLabel);
    }

    void onListSelectionChanged(IStructuredSelection structuredSelection) {
        boolean selectionNotEmpty;
        boolean bl = selectionNotEmpty = !structuredSelection.isEmpty();
        if (selectionNotEmpty) {
            this.onServerChanged((IServerDefinition)structuredSelection.getFirstElement());
            this.statusHandler.clearErrors(this);
        } else {
            this.onServerChanged(null);
            this.statusHandler.setErrorMessage(this, "Please select a Mule Server");
        }
        this.statusHandler.setPartComplete(this, selectionNotEmpty);
    }

    private void onServerChanged(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.statusHandler.notifyUpdate(this, KEY_SERVER_DEFINITION, serverDefinition);
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public void initializeDefaults() {
        if (!this.serverDefinitions.isEmpty() && this.serverDefinitions.size() > 0) {
            this.setDefaultServerSelection();
        }
    }
}

