/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;
import org.mule.tooling.utils.ObjectHolder;

public class RuntimeChooser {
    private final ObjectHolder<IServerDefinition> selectedServerDefinition;
    private RuntimeSelectionDialog selectionDialog;
    private String message;

    public RuntimeChooser(String message) {
        this.message = message;
        this.selectedServerDefinition = new ObjectHolder();
        this.selectedServerDefinition.set((Object)new MuleStudioPreference().getDefaultRuntimeSelection());
        this.selectionDialog = new RuntimeSelectionDialog();
        this.selectionDialog.open();
    }

    public IServerDefinition getSelectedRuntime() {
        return this.isRuntimeSelected() ? (IServerDefinition)this.selectedServerDefinition.get() : null;
    }

    public boolean isRuntimeSelected() {
        return this.selectionDialog.getReturnCode() == 0;
    }

    private final class RuntimeSelectionDialog
    extends SelectionDialog {
        private RuntimeSelectionDialog() {
            super(Display.getCurrent().getActiveShell());
            this.setTitle(RuntimeChooser.this.message);
        }

        protected Control createDialogArea(Composite parent) {
            Composite wrapper = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 10, 0).spacing(0, 0).applyTo(wrapper);
            GridDataFactory.fillDefaults().applyTo((Control)wrapper);
            ServerChooserComponent serverChooserComponent = new ServerChooserComponent("Please select a Runtime");
            serverChooserComponent.createControl(wrapper);
            serverChooserComponent.setServerDefinition((IServerDefinition)RuntimeChooser.this.selectedServerDefinition.get());
            serverChooserComponent.setStatusHandler(new NaiveStatusHandler(){

                @Override
                public void notifyUpdate(WizardPagePartExtension part, String key, Object value) {
                    if ("serverDefinition".equals(key)) {
                        ((RuntimeSelectionDialog)RuntimeSelectionDialog.this).RuntimeChooser.this.selectedServerDefinition.set((Object)((IServerDefinition)value));
                    }
                }
            });
            return parent;
        }

        protected boolean isResizable() {
            return false;
        }

        public boolean isHelpAvailable() {
            return false;
        }
    }
}

