/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class ProjectNameInputComponent
implements WizardPagePartExtension {
    private static final String PROJECT_NAME_COMPONENT_CSS_ID = "org-mule-tooling-ui-ProjectNameInputComponent";
    private static final int NAME_SIZE_LIMIT = 255;
    public static final String KEY_PROJECT_NAME = "projectName";
    private String specialCharacters = "'!#$()*,/:<=>?{}|%^@&`~ ";
    @WizardContext
    private PartStatusHandler statusHandler;
    @WizardContext
    private String projectName;
    private Text projectNameText;
    boolean erroneousState;

    public ProjectNameInputComponent() {
        this.statusHandler = new NaiveStatusHandler();
    }

    public ProjectNameInputComponent(PartStatusHandler handler) {
        this.statusHandler = handler;
    }

    public void changeSpecialCharactersAllowed(String characters) {
        this.specialCharacters = characters;
    }

    @Override
    public Control createControl(Composite parent) {
        Group group = UiUtils.createGroupWithTitle(parent, "", 2);
        Label nameLabel = new Label((Composite)group, 0);
        GridData labelLayoutData = GridDataFactory.swtDefaults().hint(100, -1).create();
        nameLabel.setLayoutData((Object)labelLayoutData);
        nameLabel.setText("Project Name:");
        this.projectNameText = new Text((Composite)group, 2048);
        GridData textLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create();
        this.projectNameText.setLayoutData((Object)textLayoutData);
        this.projectNameText.setTextLimit(255);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectNameInputComponent.this.onProjectNameModified(e);
            }
        });
        ThemeUtils.setCssId((Object)group, (String)PROJECT_NAME_COMPONENT_CSS_ID);
        return group;
    }

    protected void onProjectNameModified(ModifyEvent e) {
        this.projectName = this.projectNameText.getText();
        this.statusHandler.notifyUpdate(this, KEY_PROJECT_NAME, this.projectName);
        this.checkAndReport(this.projectName);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String name) {
        this.projectNameText.setText(name);
    }

    public void setStatusHandler(PartStatusHandler partStatusHandler) {
        this.statusHandler = partStatusHandler;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    @Override
    public void initializeDefaults() {
        if (this.projectName == null) {
            this.projectNameText.setText("");
        }
    }

    private void checkAndReport(String projectName) {
        String location;
        IPath projectPath;
        String name = CoreUtils.getJavaFriendlyProjectName((String)projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (name.length() == 0) {
            this.setErrorStatus("Enter a project name.");
            return;
        }
        if (name.startsWith(".")) {
            this.setErrorStatus("Project names cannot start with . (dot)");
            return;
        }
        if (name.equals("mule-project")) {
            this.setErrorStatus("Enter a valid project name.");
            return;
        }
        if (!StringUtils.isAsciiPrintable((String)projectName) || StringUtils.containsAny((String)projectName, (String)this.specialCharacters)) {
            String message = "Special characters are not allowed in the project name.";
            this.setErrorStatus(message);
            return;
        }
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            this.setErrorStatus(nameStatus.getMessage());
            return;
        }
        IProject handle = workspace.getRoot().getProject(name);
        if (handle.exists()) {
            this.setErrorStatus("A project with this name already exists.");
            return;
        }
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
        if (projectLocation.toFile().exists()) {
            try {
                String canonicalPath = projectLocation.toFile().getCanonicalPath();
                projectLocation = new Path(canonicalPath);
            }
            catch (IOException e) {
                MuleUIPlugin.getDefault().logError(e.getMessage(), e);
            }
            String existingName = projectLocation.lastSegment();
            if (existingName.equalsIgnoreCase(name)) {
                String message = String.format("There is already a folder named \"%s\" under the specified project location", TextProcessor.process((String)existingName));
                this.setErrorStatus(message);
                return;
            }
        }
        if (!(projectPath = Path.fromOSString((String)(location = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name).toOSString()))).toFile().exists() && !this.canCreate(projectPath.toFile())) {
            this.setErrorStatus("Cannot create project content at the given location.");
            return;
        }
        IStatus locationStatus = workspace.validateProjectLocation(handle, null);
        if (!locationStatus.isOK()) {
            this.setErrorStatus(locationStatus.getMessage());
            return;
        }
        this.clearErrorStatus();
    }

    private void clearErrorStatus() {
        if (this.erroneousState) {
            this.erroneousState = false;
            this.statusHandler.clearErrors(this);
            this.statusHandler.setPartComplete(this, true);
        }
    }

    private void setErrorStatus(String message) {
        this.statusHandler.setErrorMessage(this, message);
        if (!this.erroneousState) {
            this.erroneousState = true;
            this.statusHandler.setPartComplete(this, false);
        }
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    public boolean isInErroneousState() {
        return this.erroneousState;
    }
}

