/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;

public class MuleProjectsContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        Object[] elementChildren = this.getChildren(element);
        return elementChildren != null && elementChildren.length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        IMuleProject[] allMuleProjects = (IMuleProject[])inputElement;
        HashSet<Object> filteredMuleProjects = new HashSet<Object>();
        IMuleProject[] iMuleProjectArray = allMuleProjects;
        int n = allMuleProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IMuleProject muleProject = iMuleProjectArray[n2];
            if (MuleProjectKind.APPLICATION.classifies(muleProject)) {
                IMuleApplicationProject muleAppProject = (IMuleApplicationProject)muleProject;
                if (muleAppProject.getDomain() != null && muleAppProject.getDomain().isValid()) {
                    filteredMuleProjects.add(muleAppProject.getDomain());
                } else {
                    filteredMuleProjects.add(muleProject);
                }
            } else if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
                filteredMuleProjects.add(muleProject);
            }
            ++n2;
        }
        return filteredMuleProjects.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IMuleDomain) {
            IMuleDomain muleDomain = (IMuleDomain)parentElement;
            try {
                return muleDomain.getChildProjects().toArray();
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Cannot get projects for domain " + muleDomain.getDomainName()), (Throwable)e);
            }
        }
        return null;
    }
}

