/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.ui.common.MuleProjectsContentProvider;
import org.mule.tooling.ui.jface.MuleLabelProvider;
import org.mule.tooling.ui.widgets.tree.FullSelectionContainerCheckedTreeViewer;
import org.mule.tooling.ui.widgets.util.TextAndDecorationLabelProviderDecorator;

public class MuleProjectChooserComponent {
    public static final Pattern PARENTHESIS_REGEX = Pattern.compile("(.+)(\\(.+\\))");
    public static final Pattern PROBLEMS_REGEX = Pattern.compile("(.+)(<.*)");
    private String title;
    private IMuleProject[] muleProjects;
    private CheckboxTreeViewer checkboxTreeViewer;

    public MuleProjectChooserComponent(String title, IMuleProject[] muleProjects) {
        this.title = title;
        this.muleProjects = muleProjects;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.title);
        this.checkboxTreeViewer = this.createProjectsTree((Composite)group);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.checkboxTreeViewer.getTree());
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)group);
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(-1, 200).grab(true, false).applyTo((Control)group);
        this.checkboxTreeViewer.setInput((Object)this.muleProjects);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkboxTreeViewer.addCheckStateListener(listener);
    }

    public void setCheckedProjects(List<IMuleProject> selectedProjects) {
        this.checkboxTreeViewer.setCheckedElements(selectedProjects.toArray(new Object[selectedProjects.size()]));
    }

    public List<IMuleProject> getCheckedProjects() {
        Object[] checkedElements;
        LinkedList<IMuleProject> selectedProjects = new LinkedList<IMuleProject>();
        Object[] objectArray = checkedElements = this.checkboxTreeViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IMuleProject) {
                selectedProjects.add((IMuleProject)element);
            }
            ++n2;
        }
        return selectedProjects;
    }

    private CheckboxTreeViewer createProjectsTree(Composite parent) {
        FullSelectionContainerCheckedTreeViewer checkboxTreeViewer = new FullSelectionContainerCheckedTreeViewer(parent);
        checkboxTreeViewer.setAutoExpandLevel(-1);
        checkboxTreeViewer.setContentProvider((IContentProvider)new MuleProjectsContentProvider());
        checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new TextAndDecorationLabelProviderDecorator((LabelProvider)new MuleLabelProvider(){

            @Override
            protected String getProjectTypeSpecificText(IProject project) {
                try {
                    if (MuleProjectKind.APPLICATION.classifies(project)) {
                        return "";
                    }
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError((String)("There was a problem determining project kind for project: " + String.valueOf(project)), (Throwable)e);
                }
                return super.getProjectTypeSpecificText(project);
            }
        }, Arrays.asList(PROBLEMS_REGEX, PARENTHESIS_REGEX)));
        return checkboxTreeViewer;
    }
}

