/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.common.ProjectNameInputComponent;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class LocationComponent
implements WizardPagePartExtension,
IStringButtonAdapter,
IDialogFieldListener {
    private static final String LOCATION_COMPONENT_CSS_ID = "org-mule-tooling-ui-LocationComponent";
    protected final SelectionButtonDialogField fUseDefaults;
    protected final StringButtonDialogField fLocation;
    private Shell shell;
    private ProjectNameInputComponent projectNameComponent;
    @WizardContext
    private PartStatusHandler statusHandler;
    @WizardContext
    private String projectName;
    boolean erroneousState;
    private String fPreviousExternalLocation;
    private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

    public LocationComponent(Shell shell, ProjectNameInputComponent projectComponent) {
        this.shell = shell;
        this.projectNameComponent = projectComponent;
        this.statusHandler = new NaiveStatusHandler();
        this.fUseDefaults = new SelectionButtonDialogField(32);
        this.fUseDefaults.setDialogFieldListener((IDialogFieldListener)this);
        this.fUseDefaults.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_location_desc);
        this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
        this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
        this.fLocation.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
        this.fLocation.setButtonLabel(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
        this.fUseDefaults.setSelection(true);
        this.fPreviousExternalLocation = "";
    }

    @Override
    public Control createControl(Composite composite) {
        Group group = UiUtils.createGroupWithTitle(composite, "Project location", 2);
        WidgetUtils.setFontStyle((Control)group, (int)1);
        Composite locationComposite = new Composite((Composite)group, 0);
        locationComposite.setLayout((Layout)new GridLayout(4, false));
        this.fUseDefaults.doFillIntoGrid(locationComposite, 4);
        this.fLocation.doFillIntoGrid(locationComposite, 4);
        LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)locationComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        ThemeUtils.setCssId((Object)group, (String)LOCATION_COMPONENT_CSS_ID);
        return group;
    }

    protected String getDefaultPath(String name) {
        IPath path = Platform.getLocation().append(name != null ? name : "");
        return path.toOSString();
    }

    public void updateLocationText() {
        if (this.isUseDefaultSelected()) {
            this.fLocation.setText(this.getDefaultLocation());
        }
    }

    public String getDefaultLocation() {
        return this.getDefaultPath(this.getProjectName());
    }

    private String getProjectName() {
        return this.projectNameComponent.getProjectName();
    }

    public IPath getLocation() {
        if (this.isUseDefaultSelected()) {
            return Platform.getLocation();
        }
        return Path.fromOSString((String)this.fLocation.getText().trim());
    }

    public boolean isUseDefaultSelected() {
        return this.fUseDefaults.isSelected();
    }

    public void changeControlPressed(DialogField field) {
        String selectedDirectory;
        File path;
        String prevLocation;
        DirectoryDialog dialog = new DirectoryDialog(this.shell);
        dialog.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_directory_message);
        String directoryName = this.fLocation.getText().trim();
        if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
            directoryName = prevLocation;
        }
        if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
            dialog.setFilterPath(directoryName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            String oldDirectory = new Path(this.fLocation.getText().trim()).lastSegment();
            this.fLocation.setText(selectedDirectory);
            String lastSegment = new Path(selectedDirectory).lastSegment();
            if (lastSegment != null && (this.getProjectName().length() == 0 || this.getProjectName().equals(oldDirectory))) {
                this.projectNameComponent.setProjectName(lastSegment);
            }
            JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
        }
    }

    public void dialogFieldChanged(DialogField field) {
        this.validateProjectLocationPath();
        if (field == this.fUseDefaults) {
            boolean checked = this.fUseDefaults.isSelected();
            if (checked) {
                this.fPreviousExternalLocation = this.fLocation.getText();
                this.fLocation.setText(this.getDefaultLocation());
                this.fLocation.setEnabled(false);
            } else {
                this.fLocation.setText(this.fPreviousExternalLocation);
                this.fLocation.setEnabled(true);
            }
        }
    }

    @Override
    public void initializeDefaults() {
        this.fLocation.setText(this.getDefaultLocation());
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    public void setStatusHandler(PartStatusHandler partStatusHandler) {
        this.statusHandler = partStatusHandler;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.updateLocationText();
    }

    private void validateProjectLocationPath() {
        IWorkspace workspace = JavaPlugin.getWorkspace();
        String name = this.projectNameComponent.getProjectName();
        if (name != null && !name.isEmpty()) {
            String location = this.getLocation().toOSString();
            if (location.length() == 0) {
                this.setErrorStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterLocation);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                this.setErrorStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidDirectory);
                return;
            }
            IPath projectPath = null;
            if (!(this.isUseDefaultSelected() || (projectPath = Path.fromOSString((String)location)).toFile().exists() || this.canCreate(projectPath.toFile()))) {
                this.setErrorStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation);
                return;
            }
            IWorkspaceRoot root = workspace.getRoot();
            if (!root.getFullPath().isValidSegment(name)) {
                this.setErrorStatus(NewWizardMessages.VariableCreationDialog_error_invalidname);
                return;
            }
            IProject handle = root.getProject(name);
            IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
            if (!locationStatus.isOK()) {
                this.setErrorStatus(locationStatus.getMessage());
                return;
            }
        }
        this.clearErrorStatus();
    }

    private void clearErrorStatus() {
        if (this.erroneousState) {
            this.erroneousState = false;
            this.statusHandler.clearErrors(this);
            this.statusHandler.setPartComplete(this, true);
        }
    }

    private void setErrorStatus(String message) {
        this.statusHandler.setErrorMessage(this, message);
        if (!this.erroneousState) {
            this.erroneousState = true;
            this.statusHandler.setPartComplete(this, false);
        }
    }

    public boolean isInErroneousState() {
        return this.erroneousState;
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }
}

