/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.mule.tooling.core.model.IMuleProject;

public class JavaClassChooserComposite
extends Composite {
    private IMuleProject muleProject;
    private int searchType;
    private Text txtClassName;
    private Button pickButton;
    private String mustImplement;

    public JavaClassChooserComposite(IMuleProject muleProject, Composite parent, int searchType, int style) {
        super(parent, style);
        this.setMuleProject(muleProject);
        this.searchType = searchType;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.txtClassName = new Text((Composite)this, 2048);
        this.txtClassName.setLayoutData((Object)new GridData(768));
        this.pickButton = new Button((Composite)this, 0);
        this.pickButton.setText("Browse...");
        this.pickButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (JavaClassChooserComposite.this.getMustImplement() != null) {
                    JavaClassChooserComposite.this.pickFromImplementors();
                } else {
                    JavaClassChooserComposite.this.pickClass();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.txtClassName.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
    }

    protected void pickClass() {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IProject project = this.getMuleProject().getProject();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IProject)project, (int)this.searchType, (boolean)false);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                this.txtClassName.setText(type.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
    }

    protected void pickFromImplementors() {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IType myInterface = this.getMuleProject().getJavaProject().findType(this.getMustImplement());
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)myInterface);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)this.searchType, (boolean)false);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                this.txtClassName.setText(type.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
    }

    public void setClassName(String classname) {
        this.txtClassName.setText(classname == null ? "" : classname);
    }

    public String getClassName() {
        return this.txtClassName.getText();
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public String getMustImplement() {
        return this.mustImplement;
    }

    public void setMustImplement(String mustImplement) {
        this.mustImplement = mustImplement;
    }

    class TypesDialog
    extends FilteredTypesSelectionDialog {
        public TypesDialog(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
            super(parent, multi, context, scope, elementKinds);
        }

        public void setChoices(IType[] choices) {
            this.setResult(Arrays.asList(choices));
        }
    }
}

