/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.common.IPreferenceStoreBinding;
import org.mule.tooling.ui.common.NoPrefStoreBinding;
import org.mule.tooling.ui.common.internal.NaiveStatusHandler;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class GenericCheckboxComponent
implements WizardPagePartExtension {
    private static final String AGREE_LICENSE = "You need to agree to our beta license before continue";
    public static final String KEY_SELECTION = "checkboxSelection";
    private String labelText;
    private Button checkbox;
    @WizardContext
    private PartStatusHandler statusHandler;
    @WizardContext
    private boolean selection;
    private boolean isRequired = false;
    private IPreferenceStoreBinding prefStoreBinding;

    public GenericCheckboxComponent(String labelText, boolean defaultSelection) {
        this(labelText, new NoPrefStoreBinding(defaultSelection));
    }

    public GenericCheckboxComponent(String labelText, IPreferenceStoreBinding prefStoreBinding) {
        this.labelText = labelText;
        this.prefStoreBinding = prefStoreBinding;
        this.statusHandler = new NaiveStatusHandler();
    }

    public void setStatusHandler(PartStatusHandler partStatusHandler) {
        this.statusHandler = partStatusHandler;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 10).applyTo(wrapper);
        GridDataFactory.fillDefaults().applyTo((Control)wrapper);
        this.checkbox = new Button(wrapper, 32);
        this.checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenericCheckboxComponent.this.onCheckboxSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.checkbox);
        Link link = new Link(wrapper, 0);
        link.setText(this.labelText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                }
                catch (PartInitException ex) {
                    MuleCorePlugin.logError((String)"Couldn't open beta license url", (Throwable)ex);
                }
                catch (MalformedURLException ex) {
                    MuleCorePlugin.logError((String)"Couldn't open beta license url", (Throwable)ex);
                }
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)link);
        return wrapper;
    }

    protected void onCheckboxSelected() {
        this.selection = this.checkbox.getSelection();
        this.prefStoreBinding.sendValue(this.selection);
        if (this.isRequired) {
            this.checkErrors();
        }
        this.statusHandler.notifyUpdate(this, KEY_SELECTION, this.selection);
    }

    private void checkErrors() {
        if (!this.selection) {
            this.statusHandler.setErrorMessage(this, AGREE_LICENSE);
        } else {
            this.statusHandler.clearErrors(this);
        }
        this.statusHandler.setPartComplete(this, this.selection);
    }

    @Override
    public void initializeDefaults() {
        this.checkbox.setSelection(this.prefStoreBinding.getValue());
        this.onCheckboxSelected();
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    public GenericCheckboxComponent required() {
        this.isRequired = true;
        return this;
    }
}

