/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;

public class FolderChooserComposite
extends Composite {
    private Text txtFolderPath;
    private Button pickButton;
    private String filterPath;
    private List<ISelectionListener> listeners = new ArrayList<ISelectionListener>();

    public FolderChooserComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.txtFolderPath = new Text((Composite)this, 2048);
        this.txtFolderPath.setLayoutData((Object)new GridData(768));
        this.txtFolderPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderChooserComposite.this.notifyListeners(FolderChooserComposite.this.txtFolderPath.getText());
            }
        });
        this.pickButton = new Button((Composite)this, 0);
        this.pickButton.setText("...");
        this.pickButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FolderChooserComposite.this.pickFile();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void pickFile() {
        String result;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        if (this.getFilterPath() != null) {
            dialog.setFilterPath(this.getFilterPath());
        }
        if ((result = dialog.open()) != null) {
            this.txtFolderPath.setText(result);
            this.notifyListeners(result);
        }
    }

    protected void notifyListeners(String value) {
        for (ISelectionListener listener : this.listeners) {
            listener.selectionChanged(null, (ISelection)new StructuredSelection((Object)value));
        }
    }

    public void setFolderPath(String folderPath) {
        this.txtFolderPath.setText(folderPath);
    }

    public String getFolderPath() {
        return this.txtFolderPath.getText();
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public String getFilterPath() {
        return this.filterPath;
    }
}

