/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class FileChooserComposite
extends Composite {
    private Text txtFilePath;
    private Button pickButton;
    private List<ISelectionListener> listeners = new ArrayList<ISelectionListener>();
    private String[] extensions;
    private String filterPath;

    public FileChooserComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.txtFilePath = new Text((Composite)this, 2048);
        this.txtFilePath.setLayoutData((Object)new GridData(768));
        this.txtFilePath.addModifyListener(e -> this.notifyListeners(this.txtFilePath.getText()));
        this.pickButton = new Button((Composite)this, 0);
        this.pickButton.setText("...");
        this.pickButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileChooserComposite.this.pickFile();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        ThemeUtils.setCssId((Object)((Object)this), (String)"fileChooserComposite");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.txtFilePath.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.txtFilePath.addVerifyListener(listener);
    }

    public void setFilterExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    protected void pickFile() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(this.extensions);
        if (this.getFilePath() != null) {
            dialog.setFilterPath(this.getFilterPath());
        }
        if ((result = dialog.open()) != null) {
            this.txtFilePath.setText(result);
            this.notifyListeners(result);
        }
    }

    public void notifyListeners(String value) {
        for (ISelectionListener listener : this.listeners) {
            listener.selectionChanged(null, (ISelection)new StructuredSelection((Object)value));
        }
    }

    public void setFilePath(String filePath) {
        this.txtFilePath.setText(filePath);
    }

    public String getFilePath() {
        return this.txtFilePath.getText();
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setMessage(String message) {
        this.txtFilePath.setMessage(message);
    }

    protected Button getPickButton() {
        return this.pickButton;
    }
}

