/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.utils.UiUtils;

public class OpenDependenciesPage
extends AbstractHandler {
    final IDependencyViewCommand viewCommand;

    public OpenDependenciesPage(IDependencyViewCommand depViewCommand) {
        this.viewCommand = depViewCommand;
    }

    public boolean isEnabled() {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        return muleProject != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        this.viewCommand.sendMetric(muleProject, event);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IProject project = muleProject.getProject();
        this.viewCommand.openManageDependencyPage(shell, project, null);
        return null;
    }

    public static class DependencyViewCommand
    implements IDependencyViewCommand {
        private final String propertyPageId;
        private final String commandId;
        private final String eventId;

        public DependencyViewCommand(String propertyPageId, String commandId, String eventId) {
            this.propertyPageId = propertyPageId;
            this.commandId = commandId;
            this.eventId = eventId;
        }

        @Override
        public void openManageDependencyPage(Shell shell, IProject project, Object data) {
            PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)this.propertyPageId, null, (Object)data).open();
        }

        @Override
        public void sendMetric(IMuleProject project, ExecutionEvent executionEvent) {
            AnalyticsRecordsFactory.single((String)this.eventId, (IMuleProject)project).addMetadata("origin", executionEvent.getParameter(this.commandId)).track();
        }
    }

    public static interface IDependencyViewCommand {
        public void openManageDependencyPage(Shell var1, IProject var2, Object var3);

        public void sendMetric(IMuleProject var1, ExecutionEvent var2);
    }
}

