/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.command;

import java.io.File;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.InstallationException;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.ui.m2.dependency.InstallArtifactDialog;
import org.mule.tooling.ui.widgets.errors.ErrorDetailDialog;

public class InstallArtifact
extends AbstractHandler {
    private static final String SUCCESS_MESSAGE = "Successfully installed {0} into the local repository";
    private static final String DIALOG_MESSAGE = "Select a file to install into your local repository. If the file was not built with Maven, specify either a POM file or the Group ID, Artifact ID, and Version.";
    private static final String DIALOG_TITLE = "Install file into local repository";
    private static final String OK_BUTTON_LABEL = "Install";
    private MavenDependency installedArtifact;
    private final String title;
    private final String message;
    private final boolean sharedLibrary;
    private final Optional<String> successMessage;
    private Optional<String> okButtonText = Optional.empty();

    public InstallArtifact() {
        this(DIALOG_TITLE, DIALOG_MESSAGE, Optional.of(SUCCESS_MESSAGE), false);
        this.okButtonText = Optional.of(OK_BUTTON_LABEL);
    }

    public InstallArtifact(String title, String message, Optional<String> successMessage, boolean sharedLibrary) {
        this.title = title;
        this.message = message;
        this.sharedLibrary = sharedLibrary;
        this.successMessage = successMessage;
    }

    public Object execute() {
        return this.execute(new ExecutionEvent());
    }

    public Object execute(ExecutionEvent event) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        InstallArtifactDialog dialog = new InstallArtifactDialog(shell, this.title, this.message, this.okButtonText, this.sharedLibrary);
        if (dialog.open() == 0) {
            try {
                File jarFile = dialog.getArtifactFile();
                Optional<File> pomFile = dialog.getPomFile();
                MavenDependency artifact = dialog.getArtifact();
                MavenUtils.installFileToLocalRepository((File)jarFile, pomFile, (MavenDependency)artifact);
                this.successMessage.ifPresent(msg -> MessageDialog.openInformation((Shell)shell, (String)this.title, (String)MessageFormat.format(msg, jarFile.getName())));
                this.installedArtifact = artifact;
                AnalyticsRecordsFactory.single((String)Events.INSTALL_ARTIFACT_MANUALLY, (String[])new String[]{"dependency", MavenUtils.getGavString((MavenDependency)artifact)}).track();
            }
            catch (InstallationException e) {
                MuleCorePlugin.logError((String)"Unable to install artifact", (Throwable)e);
                ErrorDetailDialog.openError((Shell)shell, (String)this.title, (String)("Error: " + e.getMessage()), (String)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public Optional<MavenDependency> getInstalledArtifact() {
        return Optional.ofNullable(this.installedArtifact);
    }
}

